/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a uniform crossover between m individuals.")
public class CrossoverGAUniform
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    public CrossoverGAUniform() {
    }

    public CrossoverGAUniform(CrossoverGAUniform c) {
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverGAUniform(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (partners.size() == 0) {
            return result;
        }
        if (indy1 instanceof InterfaceGAIndividual && partners.get(0) instanceof InterfaceGAIndividual) {
            int i2;
            int length = ((InterfaceGAIndividual)((Object)indy1)).getGenotypeLength();
            int mixer = RNG.randomInt(0, partners.size());
            BitSet[][] tmpBitSet = new BitSet[2][partners.size() + 1];
            tmpBitSet[0][0] = ((InterfaceGAIndividual)((Object)indy1)).getBGenotype();
            tmpBitSet[1][0] = ((InterfaceGAIndividual)((Object)result[0])).getBGenotype();
            for (i2 = 0; i2 < partners.size(); ++i2) {
                tmpBitSet[0][i2 + 1] = ((InterfaceGAIndividual)partners.get(i2)).getBGenotype();
                tmpBitSet[1][i2 + 1] = ((InterfaceGAIndividual)((Object)result[i2 + 1])).getBGenotype();
                length = Math.max(length, ((InterfaceGAIndividual)partners.get(i2)).getGenotypeLength());
            }
            for (i2 = 0; i2 < length; ++i2) {
                mixer = RNG.randomInt(0, partners.size());
                for (int j = 0; j < tmpBitSet[0].length; ++j) {
                    if (tmpBitSet[0][(j + mixer) % tmpBitSet[0].length].get(i2)) {
                        tmpBitSet[1][j].set(i2);
                        continue;
                    }
                    tmpBitSet[1][j].clear(i2);
                }
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceGAIndividual)((Object)result[i2])).setBGenotype(tmpBitSet[1][i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverGAUniform;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "GA uniform crossover";
    }
}

