/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.crossover.CrossoverESDefault;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a discrete one-point crossover between m GI individuals.")
public class CrossoverGIDefault
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    public CrossoverGIDefault() {
    }

    public CrossoverGIDefault(CrossoverGIDefault c) {
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverGIDefault(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceGIIndividual && partners.get(0) instanceof InterfaceGIIndividual) {
            int i2;
            if (((InterfaceGIIndividual)((Object)indy1)).getIGenotype().length <= 1) {
                return result;
            }
            int crossoverpoint = RNG.randomInt(0, ((InterfaceGIIndividual)((Object)indy1)).getIGenotype().length - 1);
            boolean switcher = RNG.randomBoolean();
            int[][] parents = new int[partners.size() + 1][];
            int[][] children = new int[partners.size() + 1][];
            for (i2 = 0; i2 < result.length; ++i2) {
                parents[i2] = new int[((InterfaceGIIndividual)((Object)result[i2])).getIGenotype().length];
                children[i2] = new int[parents[i2].length];
                System.arraycopy(((InterfaceGIIndividual)((Object)result[i2])).getIGenotype(), 0, parents[i2], 0, parents[i2].length);
                System.arraycopy(((InterfaceGIIndividual)((Object)result[i2])).getIGenotype(), 0, children[i2], 0, parents[i2].length);
            }
            for (i2 = 0; i2 < children[0].length; ++i2) {
                if (i2 < crossoverpoint ^ switcher) continue;
                for (int j = 0; j < children.length - 1; ++j) {
                    if (i2 >= children[j].length || i2 >= parents[j + 1].length) continue;
                    children[j][i2] = parents[j + 1][i2];
                }
                if (i2 >= children[children.length - 1].length || i2 >= parents[0].length) continue;
                children[children.length - 1][i2] = parents[0][i2];
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceGIIndividual)((Object)result[i2])).setIGenotype(children[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverESDefault;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "GI discrete one-point crossover";
    }
}

