/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a variable length n-point crossover between m individuals.")
public class CrossoverGINPointVL
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;
    private int numberOfCrossovers = 3;

    public CrossoverGINPointVL() {
    }

    public CrossoverGINPointVL(CrossoverGINPointVL mutator) {
        this.optimizationProblem = mutator.optimizationProblem;
        this.numberOfCrossovers = mutator.numberOfCrossovers;
    }

    @Override
    public Object clone() {
        return new CrossoverGINPointVL(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (partners.size() == 0) {
            return result;
        }
        if (indy1 instanceof InterfaceGIIndividual && partners.get(0) instanceof InterfaceGIIndividual) {
            int i2;
            int[] length = new int[partners.size() + 1];
            int mixer = RNG.randomInt(0, partners.size());
            int[][] crossoverPoints = new int[length.length][this.numberOfCrossovers];
            int[][] parents = new int[partners.size() + 1][];
            int[][] offsprings = new int[partners.size() + 1][];
            length[0] = ((InterfaceGIIndividual)((Object)indy1)).getGenotypeLength();
            parents[0] = ((InterfaceGIIndividual)((Object)indy1)).getIGenotype();
            for (int i3 = 0; i3 < partners.size(); ++i3) {
                length[i3 + 1] = ((InterfaceGIIndividual)partners.get(i3)).getGenotypeLength();
                parents[i3 + 1] = ((InterfaceGIIndividual)partners.get(i3)).getIGenotype();
            }
            int[][][] fragments = this.getNFragmentsFrom(parents);
            for (i2 = 0; i2 < offsprings.length; ++i2) {
                int j;
                int index = 0;
                int tmpLen = 0;
                for (j = 0; j < this.numberOfCrossovers; ++j) {
                    tmpLen += fragments[(i2 + j) % fragments.length][index].length;
                    ++index;
                }
                offsprings[i2] = new int[tmpLen];
                index = 0;
                tmpLen = 0;
                for (j = 0; j < this.numberOfCrossovers; ++j) {
                    System.arraycopy(fragments[(i2 + j) % fragments.length][index], 0, offsprings[i2], tmpLen, fragments[(i2 + j) % fragments.length][index].length);
                    tmpLen += fragments[(i2 + j) % fragments.length][index].length;
                    ++index;
                }
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceGIIndividual)((Object)result[i2])).setIntegerDataLength(offsprings[i2].length);
                ((InterfaceGIIndividual)((Object)result[i2])).setIGenotype(offsprings[i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    private int[][][] getNFragmentsFrom(int[][] parents) {
        int[][][] result = new int[parents.length][this.numberOfCrossovers][];
        for (int i = 0; i < parents.length; ++i) {
            if (this.numberOfCrossovers + 2 > parents[i].length) {
                for (int j = 0; j < this.numberOfCrossovers; ++j) {
                    result[i][j] = new int[parents[i].length];
                    System.arraycopy(parents[i], 0, result[i][j], 0, parents[i].length);
                }
                continue;
            }
            int[] crossoverpoints = this.getCrossoverPoints(parents[i].length);
            int lastPoint = 0;
            for (int j = 0; j < this.numberOfCrossovers; ++j) {
                result[i][j] = new int[crossoverpoints[j] - lastPoint];
                System.arraycopy(parents[i], lastPoint, result[i][j], 0, crossoverpoints[j] - lastPoint);
                lastPoint = crossoverpoints[j];
            }
        }
        return result;
    }

    private int[] getCrossoverPoints(int length) {
        int[] result = new int[this.numberOfCrossovers];
        BitSet bitset = new BitSet(length);
        while (bitset.cardinality() < this.numberOfCrossovers) {
            bitset.set(RNG.randomInt(1, length - 2));
        }
        int index = 0;
        for (int i = 0; i < length; ++i) {
            if (!bitset.get(i)) continue;
            result[index] = i;
            ++index;
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        if (crossover instanceof CrossoverGINPointVL) {
            CrossoverGINPointVL cross = (CrossoverGINPointVL)crossover;
            return this.numberOfCrossovers == cross.numberOfCrossovers;
        }
        return false;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "GI var. length N-Point Crossover";
    }

    public void setNumberOfCrossovers(int crossovers) {
        if (crossovers < 0) {
            crossovers = 0;
        }
        this.numberOfCrossovers = crossovers;
    }

    public int getNumberOfCrossovers() {
        return this.numberOfCrossovers;
    }

    public String numberOfCrossoversTipText() {
        return "The number of crossoverpoints.";
    }
}

