/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a uniform crossover between m individuals.")
public class CrossoverGIUniform
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    public CrossoverGIUniform() {
    }

    public CrossoverGIUniform(CrossoverGIUniform c) {
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverGIUniform(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (partners.size() == 0) {
            return result;
        }
        if (indy1 instanceof InterfaceGIIndividual && partners.get(0) instanceof InterfaceGIIndividual) {
            int i2;
            int length = ((InterfaceGIIndividual)((Object)indy1)).getGenotypeLength();
            int mixer = RNG.randomInt(0, partners.size());
            int[][][] tmpInts = new int[2][partners.size() + 1][];
            tmpInts[0][0] = ((InterfaceGIIndividual)((Object)indy1)).getIGenotype();
            tmpInts[1][0] = ((InterfaceGIIndividual)((Object)result[0])).getIGenotype();
            for (i2 = 0; i2 < partners.size(); ++i2) {
                length = Math.max(length, ((InterfaceGIIndividual)partners.get(i2)).getGenotypeLength());
                tmpInts[0][i2 + 1] = ((InterfaceGIIndividual)partners.get(i2)).getIGenotype();
                tmpInts[1][i2 + 1] = ((InterfaceGIIndividual)((Object)result[i2 + 1])).getIGenotype();
                length = Math.max(length, ((InterfaceGIIndividual)partners.get(i2)).getGenotypeLength());
            }
            for (i2 = 0; i2 < length; ++i2) {
                mixer = RNG.randomInt(0, partners.size());
                for (int j = 0; j < tmpInts[0].length; ++j) {
                    if (tmpInts[0][(j + mixer) % tmpInts[0].length].length <= i2 || tmpInts[1][j].length <= i2) continue;
                    tmpInts[1][j][i2] = tmpInts[0][(j + mixer) % tmpInts[0].length][i2];
                }
            }
            for (i2 = 0; i2 < result.length; ++i2) {
                ((InterfaceGIIndividual)((Object)result[i2])).setIGenotype(tmpInts[1][i2]);
            }
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverGIUniform;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "GI uniform crossover";
    }
}

