/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.GPIndividualProgramData;
import eva2.optimization.individuals.InterfaceGPIndividual;
import eva2.optimization.individuals.codings.gp.AbstractGPNode;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a one-point crossover between two programs.")
public class CrossoverGPDefault
implements InterfaceCrossover,
Serializable {
    private static final long serialVersionUID = 8900427365914281930L;
    private InterfaceOptimizationProblem optimizationProblem;
    private boolean maintainMaxDepth = true;

    public CrossoverGPDefault() {
    }

    public CrossoverGPDefault(CrossoverGPDefault c) {
        this.maintainMaxDepth = c.maintainMaxDepth;
        this.optimizationProblem = c.optimizationProblem;
    }

    @Override
    public Object clone() {
        return new CrossoverGPDefault(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        if (partners.size() > 1) {
            System.err.println("Warning, crossover may not work on more than one partner! " + this.getClass());
        }
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (int i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (partners.size() == 0) {
            return result;
        }
        if (indy1 instanceof InterfaceGPIndividual && partners.get(0) instanceof InterfaceGPIndividual) {
            int allowedDepth = ((InterfaceGPIndividual)((Object)indy1)).getMaxAllowedDepth();
            AbstractGPNode[] nodes = ((InterfaceGPIndividual)((Object)result[0])).getPGenotype();
            for (int t = 0; t < nodes.length; ++t) {
                ((InterfaceGPIndividual)((Object)result[0])).getPGenotype()[t].getRandomNode();
                AbstractGPNode selNodeThis = ((InterfaceGPIndividual)((Object)result[0])).getPGenotype()[t].getRandomNode();
                AbstractGPNode selNodeOther = ((InterfaceGPIndividual)((Object)result[1])).getPGenotype()[t].getRandomNode();
                if (this.maintainMaxDepth) {
                    int maxTries;
                    for (maxTries = 10; maxTries >= 0 && (selNodeOther.getSubtreeDepth() + selNodeThis.getDepth() > allowedDepth || selNodeThis.getSubtreeDepth() + selNodeOther.getDepth() > allowedDepth); --maxTries) {
                        if (RNG.flipCoin(0.5)) {
                            selNodeThis = ((InterfaceGPIndividual)((Object)result[0])).getPGenotype()[t].getRandomNode();
                            continue;
                        }
                        selNodeOther = ((InterfaceGPIndividual)((Object)result[1])).getPGenotype()[t].getRandomNode();
                    }
                    if (maxTries < 0) {
                        selNodeThis = ((InterfaceGPIndividual)((Object)result[0])).getPGenotype()[t].getRandomLeaf();
                        selNodeOther = ((InterfaceGPIndividual)((Object)result[1])).getPGenotype()[t].getRandomLeaf();
                    }
                }
                AbstractGPNode selNodeThisParent = selNodeThis.getParent();
                AbstractGPNode selNodeOtherParent = selNodeOther.getParent();
                if (selNodeThisParent == null) {
                    ((InterfaceGPIndividual)((Object)result[0])).setPGenotype((AbstractGPNode)selNodeOther.clone(), t);
                } else {
                    selNodeThisParent.setNode((AbstractGPNode)selNodeOther.clone(), selNodeThis);
                }
                if (selNodeOtherParent == null) {
                    ((InterfaceGPIndividual)((Object)result[1])).setPGenotype((AbstractGPNode)selNodeThis.clone(), t);
                    continue;
                }
                selNodeOtherParent.setNode((AbstractGPNode)selNodeThis.clone(), selNodeOther);
            }
        }
        for (AbstractEAIndividual aResult : result) {
            ((GPIndividualProgramData)aResult).checkDepth();
            aResult.getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverGPDefault;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "GP default crossover";
    }
}

