/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceOBGAIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The infamous PMX uniform crossover for Permutations.")
public class CrossoverOBGAPMXUniform
implements InterfaceCrossover,
Serializable {
    public CrossoverOBGAPMXUniform() {
    }

    public CrossoverOBGAPMXUniform(CrossoverOBGAPMXUniform c) {
    }

    @Override
    public Object clone() {
        return new CrossoverOBGAPMXUniform(this);
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[partners.size() + 1];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        if (indy1 instanceof InterfaceOBGAIndividual && partners.get(0) instanceof InterfaceOBGAIndividual) {
            int[][] pperm1 = new int[((InterfaceOBGAIndividual)((Object)result[0])).getOBGenotype().length][];
            int[][] pperm2 = new int[((InterfaceOBGAIndividual)((Object)result[1])).getOBGenotype().length][];
            for (int i2 = 0; i2 < ((InterfaceOBGAIndividual)((Object)result[0])).getOBGenotype().length; ++i2) {
                int[] perm1 = (int[])((InterfaceOBGAIndividual)((Object)result[0])).getOBGenotype()[i2].clone();
                int[] perm2 = (int[])((InterfaceOBGAIndividual)((Object)result[1])).getOBGenotype()[i2].clone();
                int crossnumber = RNG.randomInt(1, perm1.length);
                for (int iter = 0; iter < crossnumber; ++iter) {
                    int crosspoint = RNG.randomInt(0, perm1.length - 1);
                    int p1inp2 = 0;
                    int p2inp1 = 0;
                    while (perm1[p2inp1] != perm2[crosspoint]) {
                        ++p2inp1;
                    }
                    while (perm2[p1inp2] != perm1[crosspoint]) {
                        ++p1inp2;
                    }
                    perm1[crosspoint] = perm2[crosspoint];
                    perm2[crosspoint] = perm2[p1inp2];
                    perm1[p2inp1] = perm2[crosspoint];
                    perm2[p1inp2] = perm1[crosspoint];
                }
                pperm1[i2] = perm1;
                pperm2[i2] = perm2;
            }
            ((InterfaceOBGAIndividual)((Object)result[0])).setOBGenotype(pperm1);
            ((InterfaceOBGAIndividual)((Object)result[1])).setOBGenotype(pperm2);
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof CrossoverOBGAPMXUniform;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "OBGA PMX uniform crossover";
    }
}

