/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="No crossover at all, even for occasional strategy parameters.")
public class NoCrossover
implements InterfaceCrossover,
Serializable {
    private InterfaceOptimizationProblem optimizationProblem;

    @Override
    public Object clone() {
        return new NoCrossover();
    }

    @Override
    public AbstractEAIndividual[] mate(AbstractEAIndividual indy1, Population partners) {
        int i;
        AbstractEAIndividual[] result = null;
        result = new AbstractEAIndividual[1 + partners.size()];
        result[0] = (AbstractEAIndividual)indy1.clone();
        for (i = 0; i < partners.size(); ++i) {
            result[i + 1] = (AbstractEAIndividual)((AbstractEAIndividual)partners.get(i)).clone();
        }
        for (i = 0; i < result.length; ++i) {
            result[i].getMutationOperator().crossoverOnStrategyParameters(indy1, partners);
        }
        return result;
    }

    @Override
    public boolean equals(Object crossover) {
        return crossover instanceof NoCrossover;
    }

    @Override
    public void init(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        this.optimizationProblem = opt;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName();
    }

    public String getName() {
        return "Nocrossover";
    }
}

