/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.crossover;

import eva2.gui.JParaPanel;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.ESIndividualDoubleData;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.crossover.CrossoverESUNDX;
import eva2.optimization.operator.crossover.InterfaceCrossover;
import eva2.optimization.population.Population;
import eva2.problems.F1Problem;
import eva2.problems.InterfaceOptimizationProblem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TestESCrossover
implements Serializable {
    private JFrame frame;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JComponent optionsPanel;
    private JButton initButton;
    private JButton init2Button;
    private JButton init3Button;
    private JButton crossButton;
    private InterfaceOptimizationProblem optimizationProblem = new F1Problem();
    private InterfaceCrossover crossover = new CrossoverESUNDX();
    private Population partners;
    private AbstractEAIndividual daddy;
    private int numberOfCrossovers = 100;
    private int dimension = 2;
    private int numberOfPartners = 1;
    double[] pff;
    private Plot plot;
    ActionListener initListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int i;
            TestESCrossover.this.partners = new Population();
            TestESCrossover.this.partners.setTargetSize(TestESCrossover.this.numberOfPartners);
            TestESCrossover.this.partners.clear();
            ESIndividualDoubleData tmpIndyD = new ESIndividualDoubleData();
            double[][] newRange = new double[TestESCrossover.this.dimension][2];
            for (i = 0; i < TestESCrossover.this.dimension; ++i) {
                newRange[i][0] = -2.0;
                newRange[i][1] = 2.0;
            }
            tmpIndyD.setDoubleDataLength(TestESCrossover.this.dimension);
            tmpIndyD.setDoubleRange(newRange);
            for (i = 0; i < TestESCrossover.this.partners.getTargetSize(); ++i) {
                AbstractEAIndividual tmpIndyEA = (AbstractEAIndividual)((AbstractEAIndividual)tmpIndyD).clone();
                tmpIndyEA.initialize(TestESCrossover.this.optimizationProblem);
                TestESCrossover.this.partners.add(tmpIndyEA);
            }
            TestESCrossover.this.partners.initialize();
            TestESCrossover.this.daddy = (AbstractEAIndividual)((AbstractEAIndividual)tmpIndyD).clone();
            TestESCrossover.this.daddy.initialize(TestESCrossover.this.optimizationProblem);
            TestESCrossover.this.plot.clearAll();
            TestESCrossover.this.plot.setUnconnectedPoint(-2.0, -2.0, 0);
            TestESCrossover.this.plot.setUnconnectedPoint(2.0, 2.0, 0);
            double[] x = ((InterfaceDataTypeDouble)((Object)TestESCrossover.this.daddy)).getDoubleData();
            TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 0);
            for (int i2 = 0; i2 < TestESCrossover.this.partners.size(); ++i2) {
                x = ((InterfaceDataTypeDouble)TestESCrossover.this.partners.get(i2)).getDoubleData();
                TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 0);
                TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 0);
                TestESCrossover.this.pff = x;
            }
        }
    };
    ActionListener init2Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            TestESCrossover.this.partners = new Population();
            TestESCrossover.this.partners.setTargetSize(2);
            TestESCrossover.this.partners.clear();
            ESIndividualDoubleData tmpIndyD = new ESIndividualDoubleData();
            double[][] newRange = new double[TestESCrossover.this.dimension][2];
            for (int i = 0; i < TestESCrossover.this.dimension; ++i) {
                newRange[i][0] = -2.0;
                newRange[i][1] = 2.0;
            }
            tmpIndyD.setDoubleDataLength(TestESCrossover.this.dimension);
            tmpIndyD.setDoubleRange(newRange);
            double[] tmpD = new double[]{1.0, 1.0};
            ((AbstractEAIndividual)tmpIndyD).initByValue(tmpD, TestESCrossover.this.optimizationProblem);
            AbstractEAIndividual tmpIndyEA = (AbstractEAIndividual)((AbstractEAIndividual)tmpIndyD).clone();
            tmpD = new double[]{-1.0, -1.0};
            tmpIndyEA.initByValue(tmpD, TestESCrossover.this.optimizationProblem);
            TestESCrossover.this.partners.addIndividual(tmpIndyEA);
            TestESCrossover.this.daddy = (AbstractEAIndividual)((AbstractEAIndividual)tmpIndyD).clone();
            TestESCrossover.this.plot.clearAll();
            TestESCrossover.this.plot.setUnconnectedPoint(-2.0, -2.0, 0);
            TestESCrossover.this.plot.setUnconnectedPoint(2.0, 2.0, 0);
            double[] x = ((InterfaceDataTypeDouble)((Object)TestESCrossover.this.daddy)).getDoubleData();
            TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 0);
            for (int i = 0; i < TestESCrossover.this.partners.size(); ++i) {
                x = ((InterfaceDataTypeDouble)TestESCrossover.this.partners.get(i)).getDoubleData();
                TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 0);
                TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 0);
                TestESCrossover.this.pff = x;
            }
        }
    };
    ActionListener init3Listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            TestESCrossover.this.partners = new Population();
            TestESCrossover.this.partners.setTargetSize(3);
            TestESCrossover.this.partners.clear();
            ESIndividualDoubleData tmpIndyD = new ESIndividualDoubleData();
            double[][] newRange = new double[TestESCrossover.this.dimension][2];
            for (int i = 0; i < TestESCrossover.this.dimension; ++i) {
                newRange[i][0] = -2.0;
                newRange[i][1] = 2.0;
            }
            tmpIndyD.setDoubleDataLength(TestESCrossover.this.dimension);
            tmpIndyD.setDoubleRange(newRange);
            double[] tmpD = new double[]{0.5, 1.1};
            ((AbstractEAIndividual)tmpIndyD).initByValue(tmpD, TestESCrossover.this.optimizationProblem);
            AbstractEAIndividual tmpIndyEA = (AbstractEAIndividual)((AbstractEAIndividual)tmpIndyD).clone();
            tmpD = new double[]{0.1, -0.65};
            tmpIndyEA.initByValue(tmpD, TestESCrossover.this.optimizationProblem);
            TestESCrossover.this.partners.addIndividual(tmpIndyEA);
            tmpIndyEA = (AbstractEAIndividual)((AbstractEAIndividual)tmpIndyD).clone();
            tmpD = new double[]{-0.85, 0.3};
            tmpIndyEA.initByValue(tmpD, TestESCrossover.this.optimizationProblem);
            TestESCrossover.this.partners.addIndividual(tmpIndyEA);
            TestESCrossover.this.daddy = (AbstractEAIndividual)((AbstractEAIndividual)tmpIndyD).clone();
            TestESCrossover.this.plot.clearAll();
            TestESCrossover.this.plot.setUnconnectedPoint(-2.0, -2.0, 2);
            TestESCrossover.this.plot.setUnconnectedPoint(2.0, 2.0, 2);
            double[] x = ((InterfaceDataTypeDouble)((Object)TestESCrossover.this.daddy)).getDoubleData();
            TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 0);
            for (int i = 0; i < TestESCrossover.this.partners.size(); ++i) {
                x = ((InterfaceDataTypeDouble)TestESCrossover.this.partners.get(i)).getDoubleData();
                TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 1);
                TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 1);
                TestESCrossover.this.pff = x;
            }
        }
    };
    ActionListener XListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            for (int i = 0; i < TestESCrossover.this.numberOfCrossovers; ++i) {
                AbstractEAIndividual[] result = TestESCrossover.this.crossover.mate(TestESCrossover.this.daddy, TestESCrossover.this.partners);
                for (int j = 0; j < result.length; ++j) {
                    double[] x = ((InterfaceDataTypeDouble)((Object)result[j])).getDoubleData();
                    TestESCrossover.this.plot.setUnconnectedPoint(x[0], x[1], 0);
                    TestESCrossover.this.plot.setUnconnectedPoint(TestESCrossover.this.pff[0], TestESCrossover.this.pff[1], 1);
                    TestESCrossover.this.plot.setUnconnectedPoint(2.0, 2.0, 2);
                }
            }
        }
    };

    private void initFrame() {
        this.frame = new JFrame();
        this.frame.setTitle("ES Crossover Tester");
        this.frame.setSize(300, 400);
        this.frame.setLocation(530, 50);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        this.mainPanel = new JPanel();
        this.frame.getContentPane().add(this.mainPanel);
        this.mainPanel.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.initButton = new JButton("Init");
        this.initButton.addActionListener(this.initListener);
        this.initButton.setEnabled(true);
        this.init2Button = new JButton("Init 2");
        this.init2Button.addActionListener(this.init2Listener);
        this.init2Button.setEnabled(true);
        this.init3Button = new JButton("Init 3");
        this.init3Button.addActionListener(this.init3Listener);
        this.init3Button.setEnabled(true);
        this.crossButton = new JButton("X");
        this.crossButton.addActionListener(this.XListener);
        this.crossButton.setEnabled(true);
        this.buttonPanel.add(this.initButton);
        this.buttonPanel.add(this.init2Button);
        this.buttonPanel.add(this.init3Button);
        this.buttonPanel.add(this.crossButton);
        this.mainPanel.add((Component)this.buttonPanel, "North");
        this.optionsPanel = new JParaPanel(this, "MyGUI").makePanel();
        this.mainPanel.add((Component)this.optionsPanel, "Center");
        double[] tmpD = new double[]{0.0, 0.0};
        this.plot = new Plot("ES Crossover Tester", "x", "y", tmpD, tmpD);
        this.frame.validate();
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        TestESCrossover t = new TestESCrossover();
        t.initFrame();
    }

    public void setCrossover(InterfaceCrossover NumberOfCrossovers) {
        this.crossover = NumberOfCrossovers;
    }

    public InterfaceCrossover getCrossover() {
        return this.crossover;
    }

    public String crossoverTipText() {
        return "Choose the crossovers operator.";
    }

    public void setNumberOfCrossovers(int NumberOfCrossovers) {
        this.numberOfCrossovers = NumberOfCrossovers;
    }

    public int getNumberOfCrossovers() {
        return this.numberOfCrossovers;
    }

    public String numberOfCrossoversTipText() {
        return "The number of crossovers, that are to be performed.";
    }

    public void setNumberOfPartners(int NumberOfCrossovers) {
        this.numberOfPartners = NumberOfCrossovers;
    }

    public int getNumberOfPartners() {
        return this.numberOfPartners;
    }

    public String numberOfPartnersTipText() {
        return "The number of partners, that are used.";
    }
}

