/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.distancemetric;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.tools.EVAERROR;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="A simple integral metric for real-valued types.")
public class DoubleIntegralMetric
implements InterfaceDistanceMetric,
Serializable {
    boolean oneNormed = true;

    public DoubleIntegralMetric() {
    }

    public DoubleIntegralMetric(boolean normed) {
        this.oneNormed = normed;
    }

    @Override
    public Object clone() {
        return new DoubleIntegralMetric(this.oneNormed);
    }

    @Override
    public double distance(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        double[] dIndy1 = null;
        double[] dIndy2 = null;
        if (dIndy1 == null || dIndy2 == null) {
            dIndy1 = AbstractEAIndividual.getDoublePositionShallow(indy1);
            dIndy2 = AbstractEAIndividual.getDoublePositionShallow(indy2);
        }
        if (this.oneNormed) {
            double l1 = Mathematics.sum(dIndy1);
            double l2 = Mathematics.sum(dIndy2);
            if (l1 != 1.0 || l2 != 1.0) {
                if (l1 == 0.0 || l2 == 0.0) {
                    EVAERROR.errorMsgOnce("Warning, double vector with zero sum will yield infinite distances in " + this.getClass());
                }
                dIndy1 = Mathematics.svDiv(l1, dIndy1);
                dIndy2 = Mathematics.svDiv(l2, dIndy2);
            }
        }
        double sum1 = 0.0;
        double sum2 = 0.0;
        double tmpDiff = 0.0;
        double sqrDiffSum = 0.0;
        for (int i = 0; i < dIndy1.length && i < dIndy2.length; ++i) {
            tmpDiff = (sum1 += dIndy1[i]) - (sum2 += dIndy2[i]);
            sqrDiffSum += tmpDiff * tmpDiff;
        }
        return Math.sqrt(sqrDiffSum);
    }

    public String getName() {
        return "Real-valued integral metric";
    }

    public boolean isOneNormed() {
        return this.oneNormed;
    }

    public void setOneNormed(boolean normedByLength) {
        this.oneNormed = normedByLength;
    }

    public String oneNormedTipText() {
        return "If true, both vectors are normed to unity sum before comparison.";
    }
}

