/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.distancemetric;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The euclidean metric calculates euclidean distances for individuals which have a real valued interpretation.")
public class EuclideanMetric
implements InterfaceDistanceMetric,
Serializable {
    private boolean normedByDblRange = false;

    @Override
    public Object clone() {
        return new EuclideanMetric(this);
    }

    public EuclideanMetric(EuclideanMetric a) {
        this.setNormedByDblRange(a.isNormedByDblRange());
    }

    public EuclideanMetric() {
    }

    public EuclideanMetric(boolean normed) {
        this.setNormedByDblRange(normed);
    }

    @Override
    public double distance(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        double result = 0.0;
        double[] dIndy1 = AbstractEAIndividual.getDoublePositionShallow(indy1);
        double[] dIndy2 = AbstractEAIndividual.getDoublePositionShallow(indy2);
        if (this.isNormedByDblRange()) {
            double[][] range1 = ((InterfaceDataTypeDouble)((Object)indy1)).getDoubleRange();
            double[][] range2 = ((InterfaceDataTypeDouble)((Object)indy2)).getDoubleRange();
            return EuclideanMetric.normedEuclideanDistance(dIndy1, range1, dIndy2, range2);
        }
        for (int i = 0; i < dIndy1.length && i < dIndy2.length; ++i) {
            result += Math.pow(dIndy1[i] - dIndy2[i], 2.0);
        }
        return Math.sqrt(result);
    }

    public static double normedEuclideanDistance(double[] pos1, double[][] range1, double[] pos2, double[][] range2) {
        double tmpResult = 0.0;
        double tmp = 0.0;
        for (int i = 0; i < pos1.length && i < pos2.length; ++i) {
            tmp = (pos1[i] - range1[i][0]) / (range1[i][1] - range1[i][0]) - (pos2[i] - range2[i][0]) / (range2[i][1] - range2[i][0]);
            tmpResult += tmp * tmp;
        }
        return Math.sqrt(tmpResult);
    }

    public static double squaredEuclideanDistance(double[] v1, double[] v2) {
        double result = 0.0;
        for (int i = 0; i < v1.length && i < v2.length; ++i) {
            double tmp = v1[i] - v2[i];
            result += tmp * tmp;
        }
        return result;
    }

    public static double euclideanDistance(double[] v1, double[] v2) {
        double result = 0.0;
        double tmp = 0.0;
        for (int i = 0; i < v1.length && i < v2.length; ++i) {
            tmp = v1[i] - v2[i];
            result += tmp * tmp;
        }
        return Math.sqrt(result);
    }

    public String getName() {
        return "Euclidean Metric";
    }

    public void setNormedByDblRange(boolean normedByDblRange) {
        this.normedByDblRange = normedByDblRange;
    }

    public boolean isNormedByDblRange() {
        return this.normedByDblRange;
    }
}

