/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.distancemetric;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a genotype based distance metric suited for binary data. The hamming distance is computed and normalized by chromosome length.")
public class GenotypeMetricBitSet
implements InterfaceDistanceMetric,
Serializable {
    public GenotypeMetricBitSet() {
    }

    public GenotypeMetricBitSet(GenotypeMetricBitSet a) {
    }

    @Override
    public Object clone() {
        return new GenotypeMetricBitSet(this);
    }

    @Override
    public double distance(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        return GenotypeMetricBitSet.dist(indy1, indy2);
    }

    public static double dist(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        double result = 0.0;
        int length = 0;
        if (!(indy1 instanceof InterfaceGAIndividual) || !(indy2 instanceof InterfaceGAIndividual)) {
            return 1.0;
        }
        BitSet dIndy1 = ((InterfaceGAIndividual)((Object)indy1)).getBGenotype();
        BitSet dIndy2 = ((InterfaceGAIndividual)((Object)indy2)).getBGenotype();
        length = Math.min(((InterfaceGAIndividual)((Object)indy1)).getGenotypeLength(), ((InterfaceGAIndividual)((Object)indy2)).getGenotypeLength());
        for (int i = 0; i < length; ++i) {
            if (dIndy1.get(i) == dIndy2.get(i)) {
                result += 0.0;
                continue;
            }
            result += 1.0;
        }
        return result / (double)length;
    }

    public String getName() {
        return "Binary Genotype Metric";
    }
}

