/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.distancemetric;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.tools.EVAERROR;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Uses individual object data (so far only double[]) to calculate the distance.")
public class IndividualDataMetric
implements InterfaceDistanceMetric,
Serializable {
    private String dataKey = "BestPosition";
    private InterfaceDistanceMetric baseMetric = new EuclideanMetric(true);

    public IndividualDataMetric() {
    }

    public IndividualDataMetric(String key) {
        this.dataKey = key;
    }

    public IndividualDataMetric(String key, InterfaceDistanceMetric bMetric) {
        this.dataKey = key;
        this.setBaseMetric(bMetric);
    }

    public IndividualDataMetric(IndividualDataMetric o) {
        this.dataKey = o.dataKey;
        this.setBaseMetric(o.getBaseMetric());
    }

    @Override
    public Object clone() {
        return new IndividualDataMetric(this);
    }

    @Override
    public double distance(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        if (this.dataKey == null) {
            throw new RuntimeException("Error, no data key defined in " + this.getClass().getName() + "::distance()");
        }
        Object data1 = indy1.getData(this.dataKey);
        Object data2 = indy2.getData(this.dataKey);
        if (data1 instanceof double[] && data2 instanceof double[]) {
            AbstractEAIndividual dataIndy1 = (AbstractEAIndividual)indy1.clone();
            AbstractEAIndividual.setDoublePosition(dataIndy1, (double[])data1);
            AbstractEAIndividual dataIndy2 = (AbstractEAIndividual)indy2.clone();
            AbstractEAIndividual.setDoublePosition(dataIndy2, (double[])data2);
            return this.getBaseMetric().distance(dataIndy1, dataIndy2);
        }
        EVAERROR.errorMsgOnce("Error, invalid key data, double array required by " + this.getClass().getName());
        EVAERROR.errorMsgOnce("Using PhenotypeMetric as Backup...");
        return new PhenotypeMetric().distance(indy1, indy2);
    }

    public String dataKeyTipText() {
        return "Name of the data key to use to retrieve individual data (double[] for now).";
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    public String normedDistanceTipText() {
        return "Flag whether to use euclidean distance directly or normed by the double range.";
    }

    public void setBaseMetric(InterfaceDistanceMetric baseMetric) {
        this.baseMetric = baseMetric;
    }

    public InterfaceDistanceMetric getBaseMetric() {
        return this.baseMetric;
    }

    public String baseMetricTipText() {
        return "The metric to be used on the stored data objects.";
    }
}

