/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.distancemetric;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The objective space metric calculates euclidian distances on the fitness vectors.")
public class ObjectiveSpaceMetric
implements InterfaceDistanceMetric,
Serializable {
    public ObjectiveSpaceMetric() {
    }

    public ObjectiveSpaceMetric(ObjectiveSpaceMetric a) {
    }

    @Override
    public Object clone() {
        return new ObjectiveSpaceMetric(this);
    }

    @Override
    public double distance(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        double result = 0.0;
        double[] dIndy1 = indy1.getFitness();
        double[] dIndy2 = indy2.getFitness();
        for (int i = 0; i < dIndy1.length && i < dIndy2.length; ++i) {
            result += Math.pow(dIndy1[i] - dIndy2[i], 2.0);
        }
        return Math.sqrt(result);
    }

    public String getName() {
        return "Objective Space Metric";
    }
}

