/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.distancemetric;

import eva2.gui.BeanInspector;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeBinary;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.individuals.InterfaceDataTypeInteger;
import eva2.optimization.individuals.InterfaceDataTypePermutation;
import eva2.optimization.individuals.InterfaceDataTypeProgram;
import eva2.optimization.operator.distancemetric.GenotypeMetricBitSet;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This is a phenotype based metric which can be applied to binary, integer, double, permutation, and program data types. For the latter two, the Levenshtein distance is computed. All distance values are normed.")
public class PhenotypeMetric
implements InterfaceDistanceMetric,
Serializable {
    private static PhenotypeMetric pMetric = null;
    private static GenotypeMetricBitSet bitMetric = null;

    public PhenotypeMetric() {
    }

    public PhenotypeMetric(PhenotypeMetric a) {
    }

    @Override
    public Object clone() {
        return new PhenotypeMetric(this);
    }

    private static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    private static int computeLevenshteinDistance(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = PhenotypeMetric.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    @Override
    public double distance(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        Object r2;
        Object[] d2;
        Object r1;
        Object[] d1;
        double tmpResult;
        double result = 0.0;
        if (indy1 instanceof InterfaceDataTypeBinary && indy2 instanceof InterfaceDataTypeBinary) {
            if (bitMetric == null) {
                bitMetric = new GenotypeMetricBitSet();
            }
            result += bitMetric.distance(indy1, indy2);
        }
        if (indy1 instanceof InterfaceDataTypeInteger && indy2 instanceof InterfaceDataTypeInteger) {
            tmpResult = 0.0;
            d1 = ((InterfaceDataTypeInteger)((Object)indy1)).getIntegerData();
            r1 = ((InterfaceDataTypeInteger)((Object)indy1)).getIntRange();
            d2 = ((InterfaceDataTypeInteger)((Object)indy2)).getIntegerData();
            r2 = ((InterfaceDataTypeInteger)((Object)indy2)).getIntRange();
            for (int i = 0; i < d1.length && i < d2.length; ++i) {
                tmpResult += Math.pow((double)(d1[i] - r1[i][0]) / (double)(r1[i][1] - r1[i][0]) - (double)(d2[i] - r2[i][0]) / (double)(r2[i][1] - r2[i][0]), 2.0);
            }
            result += Math.sqrt(tmpResult);
        }
        if (indy1 instanceof InterfaceDataTypeDouble && indy2 instanceof InterfaceDataTypeDouble) {
            tmpResult = 0.0;
            double tmp = 0.0;
            d1 = ((InterfaceDataTypeDouble)((Object)indy1)).getDoubleData();
            r1 = ((InterfaceDataTypeDouble)((Object)indy1)).getDoubleRange();
            d2 = ((InterfaceDataTypeDouble)((Object)indy2)).getDoubleData();
            r2 = ((InterfaceDataTypeDouble)((Object)indy2)).getDoubleRange();
            for (int i = 0; i < d1.length && i < d2.length; ++i) {
                tmp = (d1[i] - r1[i][0]) / (r1[i][1] - r1[i][0]) - (d2[i] - r2[i][0]) / (r2[i][1] - r2[i][0]);
                tmpResult += tmp * tmp;
            }
            result += Math.sqrt(tmpResult);
        }
        if (indy1 instanceof InterfaceDataTypePermutation && indy2 instanceof InterfaceDataTypePermutation) {
            String s1 = "";
            String s2 = "";
            for (int p = 0; p < ((InterfaceDataTypePermutation)((Object)indy1)).getPermutationData().length; ++p) {
                int i;
                int[] dIndy1 = ((InterfaceDataTypePermutation)((Object)indy1)).getPermutationData()[p];
                int[] dIndy2 = ((InterfaceDataTypePermutation)((Object)indy2)).getPermutationData()[p];
                for (i = 0; i < dIndy1.length; ++i) {
                    s1 = s1 + dIndy1[i];
                }
                for (i = 0; i < dIndy2.length; ++i) {
                    s2 = s2 + dIndy2[i];
                }
                result += (double)PhenotypeMetric.computeLevenshteinDistance(s1, s2) / (double)Math.max(s1.length(), s2.length());
            }
        }
        if (indy1 instanceof InterfaceDataTypeProgram && indy2 instanceof InterfaceDataTypeProgram) {
            int l1 = Math.min(((InterfaceDataTypeProgram)((Object)indy1)).getProgramData().length, ((InterfaceDataTypeProgram)((Object)indy2)).getProgramData().length);
            for (int i = 0; i < l1; ++i) {
                String s1 = ((InterfaceDataTypeProgram)((Object)indy1)).getProgramData()[i].getStringRepresentation();
                String s2 = ((InterfaceDataTypeProgram)((Object)indy2)).getProgramData()[i].getStringRepresentation();
                result += (double)PhenotypeMetric.computeLevenshteinDistance(s1, s2) / (double)Math.max(s1.length(), s2.length());
            }
        }
        return result;
    }

    public static double dist(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        if (pMetric == null) {
            pMetric = new PhenotypeMetric();
        }
        return pMetric.distance(indy1, indy2);
    }

    public static double norm(AbstractEAIndividual indy) {
        double result = 0.0;
        if (indy instanceof InterfaceDataTypeBinary) {
            BitSet bs = ((InterfaceDataTypeBinary)((Object)indy)).getBinaryData();
            for (int i = 0; i < ((InterfaceDataTypeBinary)((Object)indy)).size(); ++i) {
                if (!bs.get(i)) continue;
                result += 1.0;
            }
            return result /= (double)((InterfaceDataTypeBinary)((Object)indy)).size();
        }
        if (indy instanceof InterfaceDataTypeInteger) {
            int[] d1 = ((InterfaceDataTypeInteger)((Object)indy)).getIntegerData();
            for (int i = 0; i < d1.length; ++i) {
                result += (double)d1[i];
            }
            return result / (double)d1.length;
        }
        if (indy instanceof InterfaceDataTypeDouble) {
            result = PhenotypeMetric.norm(((InterfaceDataTypeDouble)((Object)indy)).getDoubleData());
            return result;
        }
        if (indy instanceof InterfaceDataTypePermutation) {
            return 1.0;
        }
        if (indy instanceof InterfaceDataTypeProgram) {
            return 1.0;
        }
        System.err.println("error: unknown individual interface in PhenotypeMetric::norm " + BeanInspector.toString(indy));
        return 0.0;
    }

    public static double norm(double[] v1) {
        double result = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            result += Math.pow(v1[i], 2.0);
        }
        return Math.sqrt(result);
    }

    public String getName() {
        return "Phenotype Metric";
    }
}

