/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.distancemetric;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.mutation.MutateESGlobal;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is an experimental method for individuals using global ES mutation.")
public class SigmaSingleMetricGlobalMutation
implements InterfaceDistanceMetric,
Serializable {
    public SigmaSingleMetricGlobalMutation() {
    }

    public SigmaSingleMetricGlobalMutation(SigmaSingleMetricGlobalMutation a) {
    }

    @Override
    public Object clone() {
        return new SigmaSingleMetricGlobalMutation(this);
    }

    @Override
    public double distance(AbstractEAIndividual indy1, AbstractEAIndividual indy2) {
        double result = 0.0;
        if (indy1.getMutationOperator() instanceof MutateESGlobal && indy2.getMutationOperator() instanceof MutateESGlobal) {
            MutateESGlobal mutator1 = (MutateESGlobal)indy1.getMutationOperator();
            MutateESGlobal mutator2 = (MutateESGlobal)indy2.getMutationOperator();
            double[] dIndy1 = ((InterfaceDataTypeDouble)((Object)indy1)).getDoubleData();
            double[][] range1 = ((InterfaceDataTypeDouble)((Object)indy1)).getDoubleRange();
            double[] dIndy2 = ((InterfaceDataTypeDouble)((Object)indy2)).getDoubleData();
            double[][] range2 = ((InterfaceDataTypeDouble)((Object)indy2)).getDoubleRange();
            for (int i = 0; i < dIndy1.length && i < dIndy2.length; ++i) {
                result += Math.pow((dIndy1[i] - range1[i][0]) / (range1[i][1] - range1[i][0]) - (dIndy2[i] - range2[i][0]) / (range2[i][1] - range2[i][0]), 2.0);
            }
            if ((result = Math.sqrt(result)) < Math.max(mutator1.getMutationStepSize(), mutator2.getMutationStepSize())) {
                return 0.0;
            }
            return 1.0;
        }
        return 1.0;
    }

    public String getName() {
        return "Phenotype Metric Including MutateESGlobal";
    }
}

