/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.fitnessmodifier;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.cluster.ClusteringDensityBased;
import eva2.optimization.operator.cluster.InterfaceClustering;
import eva2.optimization.operator.fitnessmodifier.InterfaceFitnessModifier;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is a normation method based on Fitness Sharing. It adds a penalty for too similar individuals on the standard Normation method.")
public class FitnessAdaptiveClustering
implements Serializable,
InterfaceFitnessModifier {
    private InterfaceClustering clusteringAlgorithm = new ClusteringDensityBased();

    @Override
    public void modifyFitness(Population population) {
        double[][] data = new double[population.size()][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((AbstractEAIndividual)population.get(i)).getFitness();
        }
        double min = Double.POSITIVE_INFINITY;
        double[] result = new double[data.length];
        for (int x = 0; x < data[0].length; ++x) {
            int i;
            int i2;
            for (i2 = 0; i2 < data.length; ++i2) {
                data[i2][x] = -data[i2][x];
            }
            for (i2 = 0; i2 < data.length; ++i2) {
                if (!(data[i2][x] < min)) continue;
                min = data[i2][x];
            }
            for (i2 = 0; i2 < data.length; ++i2) {
                result[i2] = data[i2][x] - min + 0.1;
            }
            this.clusteringAlgorithm.initClustering(population);
            Population[] ClusterResult = this.clusteringAlgorithm.cluster(population, population);
            for (i = 1; i < ClusterResult.length; ++i) {
                Population cluster = ClusterResult[i];
                for (int j = 0; j < cluster.size(); ++j) {
                    int n = i;
                    result[n] = result[n] / (double)cluster.size();
                }
            }
            for (i = 0; i < population.size(); ++i) {
                ((AbstractEAIndividual)population.get(i)).SetFitness(x, result[i]);
            }
        }
    }

    public InterfaceClustering getClusteringAlgorithm() {
        return this.clusteringAlgorithm;
    }

    public void setClusteringAlgorithm(InterfaceClustering b) {
        this.clusteringAlgorithm = b;
    }

    public String clusteringAlgorithmTipText() {
        return "The Cluster Algorithm on which the adaptive fitness sharing is based.";
    }
}

