/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.fitnessmodifier;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.distancemetric.InterfaceDistanceMetric;
import eva2.optimization.operator.distancemetric.PhenotypeMetric;
import eva2.optimization.operator.fitnessmodifier.InterfaceFitnessModifier;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;

@Description(value="This is a normation method based on Fitness Sharing. It adds a penalty for too similar individuals on the standard Normation method.")
public class FitnessSharing
implements Serializable,
InterfaceFitnessModifier {
    private double sharingDistance = 0.05;
    private InterfaceDistanceMetric distanceMetric = new PhenotypeMetric();

    @Override
    public void modifyFitness(Population population) {
        double[][] data = new double[population.size()][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ((AbstractEAIndividual)population.get(i)).getFitness();
        }
        double min = Double.POSITIVE_INFINITY;
        double[] result = new double[data.length];
        for (int x = 0; x < data[0].length; ++x) {
            int i;
            for (i = 0; i < data.length; ++i) {
                data[i][x] = -data[i][x];
            }
            for (i = 0; i < data.length; ++i) {
                if (!(data[i][x] < min)) continue;
                min = data[i][x];
            }
            for (i = 0; i < data.length; ++i) {
                result[i] = data[i][x] - min + 0.1;
            }
            i = 0;
            while (i < population.size()) {
                AbstractEAIndividual tmpIndy = (AbstractEAIndividual)population.get(i);
                double fitnessSharing = 0.0;
                for (int j = 0; j < population.size(); ++j) {
                    if (!(this.sharingDistance < this.distanceMetric.distance(tmpIndy, (AbstractEAIndividual)population.get(j)))) continue;
                    fitnessSharing += 1.0 - this.distanceMetric.distance(tmpIndy, (AbstractEAIndividual)population.get(j)) / this.sharingDistance;
                }
                int n = i++;
                result[n] = result[n] / fitnessSharing;
            }
            for (i = 0; i < population.size(); ++i) {
                ((AbstractEAIndividual)population.get(i)).SetFitness(x, result[i]);
            }
        }
    }

    @Parameter(description="The threshold for the similarity penalty.")
    public void setSharingDistance(double sharingDistance) {
        this.sharingDistance = sharingDistance;
    }

    public double getSharingDistance() {
        return this.sharingDistance;
    }

    @Parameter(name="metric", description="The distance metric used. Note: This depends on the type of EAIndividual used!")
    public void setMetric(InterfaceDistanceMetric metric) {
        this.distanceMetric = metric;
    }

    public InterfaceDistanceMetric getMetric() {
        return this.distanceMetric;
    }
}

