/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.initialization;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.initialization.InterfaceInitialization;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="A method which initializes with a fixed number of occurences per segment, which is a fixed-length substring of equal length. In the binary case, thus the cardinality of each segment can be predefined.")
public class GAGIInitializeSegmentwise
implements InterfaceInitialization,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int[] bitsPerSegmentArray = new int[0];
    private int bitsPerSegment = 1;
    private int segmentLength = 4;
    private int targetElement = 1;
    private int[] otherElements = new int[0];
    private double disturbanceDegree = 0.0;

    public GAGIInitializeSegmentwise() {
    }

    public GAGIInitializeSegmentwise(GAGIInitializeSegmentwise o) {
        this.bitsPerSegment = o.bitsPerSegment;
        this.segmentLength = o.segmentLength;
        this.targetElement = o.targetElement;
        if (o.otherElements != null) {
            this.otherElements = new int[o.otherElements.length];
            System.arraycopy(o.otherElements, 0, this.otherElements, 0, this.otherElements.length);
        }
        if (o.bitsPerSegmentArray != null) {
            this.bitsPerSegmentArray = new int[o.bitsPerSegmentArray.length];
            System.arraycopy(o.bitsPerSegmentArray, 0, this.bitsPerSegmentArray, 0, this.bitsPerSegmentArray.length);
        }
        this.disturbanceDegree = o.disturbanceDegree;
    }

    public GAGIInitializeSegmentwise(int segLen, int bitsPerSeg, double disturbanceRatio) {
        this.segmentLength = segLen;
        this.bitsPerSegmentArray = new int[0];
        this.bitsPerSegment = bitsPerSeg;
        this.disturbanceDegree = disturbanceRatio;
    }

    public GAGIInitializeSegmentwise(int segLen, int[] bitsPerSegArr, double disturbanceRatio) {
        this.segmentLength = segLen;
        this.bitsPerSegmentArray = bitsPerSegArr;
        this.disturbanceDegree = disturbanceRatio;
    }

    public GAGIInitializeSegmentwise(int segLen, int[] bitsPerSeg) {
        this(segLen, bitsPerSeg, 0.0);
    }

    public GAGIInitializeSegmentwise(int segLen, int[] bitsPerSeg, int targetElement, int[] otherElements, double disturbRatio) {
        this.segmentLength = segLen;
        this.bitsPerSegmentArray = bitsPerSeg;
        this.targetElement = targetElement;
        this.otherElements = otherElements;
        this.disturbanceDegree = disturbRatio;
    }

    @Override
    public InterfaceInitialization clone() {
        return new GAGIInitializeSegmentwise(this);
    }

    @Override
    public void initialize(AbstractEAIndividual indy, InterfaceOptimizationProblem problem) {
        if (indy instanceof InterfaceGAIndividual || indy instanceof InterfaceGIIndividual) {
            int genotypeLen = -1;
            Object genotype = null;
            int[][] intRange = null;
            if (indy instanceof InterfaceGAIndividual) {
                genotypeLen = ((InterfaceGAIndividual)((Object)indy)).getGenotypeLength();
                genotype = ((InterfaceGAIndividual)((Object)indy)).getBGenotype();
            } else {
                genotypeLen = ((InterfaceGIIndividual)((Object)indy)).getGenotypeLength();
                genotype = ((InterfaceGIIndividual)((Object)indy)).getIGenotype();
                intRange = ((InterfaceGIIndividual)((Object)indy)).getIntRange();
            }
            if (this.bitsPerSegmentArray == null || this.bitsPerSegmentArray.length == 0) {
                for (int i = 0; i < genotypeLen; i += this.segmentLength) {
                    BitSet nextSeg = RNG.randomBitSet(this.bitsPerSegment, this.segmentLength);
                    this.setNewVals(nextSeg, genotype, i, genotypeLen, intRange);
                }
            } else {
                if (this.bitsPerSegmentArray.length * this.segmentLength != genotypeLen) {
                    EVAERROR.errorMsgOnce("Warning, potential mismatch between segment lengths and genotype length in " + this.getClass());
                }
                if (this.bitsPerSegmentArray.length * this.segmentLength < genotypeLen) {
                    System.err.println("Warning, " + (genotypeLen - this.bitsPerSegmentArray.length * this.segmentLength) + " bits will not be initialized!");
                }
                for (int s = 0; s < this.bitsPerSegmentArray.length; ++s) {
                    BitSet nextSeg = RNG.randomBitSet(this.bitsPerSegmentArray[s], this.segmentLength);
                    this.setNewVals(nextSeg, genotype, s * this.segmentLength, genotypeLen, intRange);
                }
            }
            if (this.disturbanceDegree > 0.0) {
                this.disturb(indy, genotype, genotypeLen, intRange);
            }
            if (indy instanceof InterfaceGAIndividual) {
                ((InterfaceGAIndividual)((Object)indy)).setBGenotype((BitSet)genotype);
            } else {
                ((InterfaceGIIndividual)((Object)indy)).setIGenotype((int[])genotype);
            }
        } else {
            throw new RuntimeException("Error: " + this.getClass() + " must be used with binary or integer individuals!");
        }
    }

    private void disturb(AbstractEAIndividual indy, Object genotype, int genotypeLen, int[][] intRange) {
        for (int i = 0; i < genotypeLen; ++i) {
            if (!RNG.flipCoin(this.disturbanceDegree)) continue;
            this.setRandomValue(i, genotype, intRange);
        }
    }

    private void setRandomValue(int i, Object genotype, int[][] range) {
        if (genotype instanceof BitSet) {
            BitSet geno = (BitSet)genotype;
            geno.set(i, RNG.randomBoolean());
        } else if (genotype instanceof int[]) {
            int[] geno = (int[])genotype;
            if (this.otherElements.length > 0) {
                int rnd = RNG.randomInt(0, this.otherElements.length);
                geno[i] = rnd == this.otherElements.length ? this.targetElement : this.otherElements[rnd];
            } else {
                if (range == null) {
                    System.err.println("Error, missing int range to perform random disturbance in " + this.getClass());
                }
                geno[i] = RNG.randomInt(range[i][0], range[i][1]);
            }
        }
    }

    private void setNewVals(BitSet nextSeg, Object genotype, int offset, int maxLen, int[][] intRange) {
        for (int k = offset; k < offset + this.segmentLength; ++k) {
            if (k >= maxLen) continue;
            if (genotype instanceof BitSet) {
                ((BitSet)genotype).set(k, this.getBoolVal(nextSeg.get(k - offset)));
                continue;
            }
            if (!(genotype instanceof int[])) continue;
            ((int[])genotype)[k] = this.getIntVal(nextSeg.get(k - offset), k, intRange);
        }
    }

    private int getIntVal(boolean initBit, int pos, int[][] range) {
        if (initBit) {
            return this.targetElement;
        }
        if (this.otherElements == null || this.otherElements.length == 0) {
            int rangeLenMinusOne = range[pos][1] - range[pos][0];
            int newVal = RNG.randomInt(rangeLenMinusOne);
            if (newVal >= this.targetElement) {
                ++newVal;
            }
            return newVal;
        }
        int k = RNG.randomInt(this.otherElements.length);
        return this.otherElements[k];
    }

    private boolean getBoolVal(boolean initBit) {
        if (initBit) {
            return this.targetElement == 1;
        }
        return this.targetElement != 1;
    }

    public int[] getTargetElementsPerSegmentArray() {
        return this.bitsPerSegmentArray;
    }

    public void setTargetElementsPerSegmentArray(int[] bitsPerSegmentArray) {
        this.bitsPerSegmentArray = bitsPerSegmentArray;
    }

    public String targetElementsPerSegmentArrayTipText() {
        return "A value per segment defining the number of target elements to set for that segment, or null if fixed";
    }

    public int getTargetElementsPerSegment() {
        return this.bitsPerSegment;
    }

    public void setTargetElementsPerSegment(int bitsPerSegment) {
        this.bitsPerSegment = bitsPerSegment;
    }

    public String targetElementsPerSegmentTipText() {
        return "If not defined as an array, this fixed number of target elements is set per segment";
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(int segmentLength) {
        this.segmentLength = segmentLength;
    }

    public String segmentLengthTipText() {
        return "The fixed length of a segment, which is a substring of the binary genotype";
    }

    public String getName() {
        return "GA-GI segment-wise initialize";
    }

    public int getTargetElement() {
        return this.targetElement;
    }

    public void setTargetElement(int elementToSet) {
        this.targetElement = elementToSet;
    }

    public String targetElementTipText() {
        return "The element to set in a defined number per segment";
    }

    public int[] getOtherElements() {
        return this.otherElements;
    }

    public void setOtherElements(int[] elementsNotToSet) {
        this.otherElements = elementsNotToSet;
    }

    public String otherElementsTipText() {
        return "Set of elements at the rest of instances among which is chosen randomly - if empty, all allowed ones except for the elementToSet are used.";
    }
}

