/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.migration;

import eva2.optimization.operator.migration.InterfaceMigration;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectMOMaxiMin;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is multi-objective migration scheme.")
public class MOBestMigration
implements InterfaceMigration,
Serializable {
    private InterfaceSelection selection = new SelectMOMaxiMin();
    int n = 5;

    @Override
    public Object clone() {
        return new MOBestMigration();
    }

    @Override
    public void initializeMigration(InterfaceOptimizer[] islands) {
    }

    @Override
    public void migrate(InterfaceOptimizer[] islands) {
        int i;
        Population[] oldIPOP = new Population[islands.length];
        Population[] newIPOP = new Population[islands.length];
        for (i = 0; i < islands.length; ++i) {
            oldIPOP[i] = islands[i].getPopulation();
            newIPOP[i] = (Population)oldIPOP[i].clone();
        }
        for (i = 0; i < newIPOP.length; ++i) {
            Population[] comSet = oldIPOP;
            newIPOP[i].removeNIndividuals(comSet.length * this.n);
            for (int j = 0; j < comSet.length; ++j) {
                Population selected = this.selection.selectFrom(comSet[j], this.n);
                newIPOP[i].addPopulation((Population)selected.clone());
            }
        }
        for (i = 0; i < islands.length; ++i) {
            islands[i].setPopulation(newIPOP[i]);
        }
    }

    public String getName() {
        return "MOBestMigration";
    }

    public InterfaceSelection getSelection() {
        return this.selection;
    }

    public void setSelection(InterfaceSelection b) {
        this.selection = b;
    }

    public String selectionTipText() {
        return "Choose the selection method for migration.";
    }

    public int getN() {
        return this.n;
    }

    public void setN(int b) {
        if (b < 1) {
            b = 1;
        }
        this.n = b;
    }

    public String nTipText() {
        return "The number of individuals to migrate per migration event.";
    }
}

