/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.migration;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingNSGAII;
import eva2.optimization.operator.cluster.ClusteringKMeans;
import eva2.optimization.operator.constraint.ConstBelongsToDifferentClass;
import eva2.optimization.operator.migration.InterfaceMigration;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconText;
import eva2.util.annotation.Description;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;

@Description(value="This is migration scheme, which implements a clustering based partitioning.")
public class MOClusteringSeparation
implements InterfaceMigration,
Serializable {
    public boolean debug = false;
    private ClusteringKMeans kMeans = new ClusteringKMeans();
    private ArchivingNSGAII NSGAII = new ArchivingNSGAII();
    private boolean useConstraints = true;
    private boolean reuseC = false;
    private InterfaceSelection selection = new SelectRandom();

    public MOClusteringSeparation() {
    }

    public MOClusteringSeparation(MOClusteringSeparation b) {
        this.debug = b.debug;
        this.useConstraints = b.useConstraints;
        if (b.kMeans != null) {
            this.kMeans = (ClusteringKMeans)b.kMeans.clone();
        }
        if (b.NSGAII != null) {
            this.NSGAII = (ArchivingNSGAII)b.NSGAII.clone();
        }
        if (b.selection != null) {
            this.selection = (InterfaceSelection)b.selection.clone();
        }
    }

    @Override
    public Object clone() {
        return new MOClusteringSeparation(this);
    }

    @Override
    public void initializeMigration(InterfaceOptimizer[] islands) {
        if (this.reuseC) {
            this.kMeans.resetC();
        }
    }

    @Override
    public void migrate(InterfaceOptimizer[] islands) {
        Population[] oldIPOP = new Population[islands.length];
        Population[] newIPOP = new Population[islands.length];
        Population collector = new Population();
        for (int i = 0; i < islands.length; ++i) {
            oldIPOP[i] = islands[i].getPopulation();
            if (this.debug) {
                System.out.println("Got population from " + i + " of size " + oldIPOP[i].size());
            }
            collector.addPopulation((Population)oldIPOP[i].clone());
            newIPOP[i] = new Population();
        }
        Population memory = (Population)collector.clone();
        Population[] archives = this.NSGAII.getNonDominatedSortedFronts(collector);
        Population toCluster = new Population();
        int currentFront = 0;
        toCluster.addPopulation(archives[currentFront]);
        while (toCluster.size() < islands.length) {
            toCluster.addPopulation(archives[++currentFront]);
        }
        this.kMeans.setK(islands.length);
        this.kMeans.cluster(toCluster, (Population)null);
        double[][] c = this.kMeans.getC();
        newIPOP = this.kMeans.cluster(collector, c);
        if (this.debug) {
            DPointIconText tmp;
            DPoint myPoint;
            GraphPointSet mySet;
            int i;
            double[] tmpD = new double[]{0.0, 0.0};
            Plot plot = new Plot("Debugging Clustering Separation", "Y1", "Y2", tmpD, tmpD);
            for (i = 0; i < newIPOP.length; ++i) {
                mySet = new GraphPointSet(11, plot.getFunctionArea());
                mySet.setConnectedMode(false);
                for (int j = 0; j < newIPOP[i].size(); ++j) {
                    AbstractEAIndividual indy = (AbstractEAIndividual)newIPOP[i].get(j);
                    myPoint = new DPoint(indy.getFitness()[0], indy.getFitness()[1]);
                    tmp = new DPointIconText("" + i);
                    myPoint.setIcon(tmp);
                    mySet.addDPoint(myPoint);
                }
            }
            mySet = new GraphPointSet(12, plot.getFunctionArea());
            mySet.setConnectedMode(false);
            for (i = 0; i < c.length; ++i) {
                myPoint = new DPoint(c[i][0], c[i][1]);
                tmp = new DPointIconText("" + i);
                tmp.setIcon(new DPointIconCircle());
                myPoint.setIcon(tmp);
                mySet.addDPoint(myPoint);
            }
        }
        if (this.useConstraints) {
            for (int i = 0; i < islands.length; ++i) {
                InterfaceOptimizationProblem prob = islands[i].getProblem();
                if (!(prob instanceof AbstractMultiObjectiveOptimizationProblem)) continue;
                ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.clear();
                double[] myClass = c[i];
                double[][] myOtherClass = new double[c.length - 1][];
                int index = 0;
                for (int j = 0; j < myOtherClass.length; ++j) {
                    if (index == i) {
                        ++index;
                    }
                    myOtherClass[j] = c[index];
                    ++index;
                }
                ConstBelongsToDifferentClass b = new ConstBelongsToDifferentClass(myClass, myOtherClass, this.kMeans.getUseSearchSpace());
                ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.add(b);
                islands[i].setProblem(prob);
            }
        }
        for (int i = 0; i < islands.length; ++i) {
            oldIPOP[i].clear();
            oldIPOP[i].addPopulation(newIPOP[i]);
            if (!oldIPOP[i].targetSizeReached()) {
                oldIPOP[i].addPopulation(this.selection.selectFrom(memory, oldIPOP[i].getTargetSize() - oldIPOP[i].size()));
            }
            if (this.debug) {
                System.out.println("Setting " + i + " to population size " + oldIPOP[i].size());
            }
            islands[i].setPopulation(oldIPOP[i]);
        }
    }

    private void writeToFile(BufferedWriter out, String line) {
        String write = line + "\n";
        write.replaceAll(",", ".");
        if (out == null) {
            return;
        }
        try {
            out.write(write, 0, write.length());
            out.flush();
        }
        catch (IOException e) {
            System.out.println("Problems writing to output file!");
        }
    }

    public String getName() {
        return "MOClusteringSeparation";
    }

    public ClusteringKMeans getKMeans() {
        return this.kMeans;
    }

    public void setKMeans(ClusteringKMeans b) {
        this.kMeans = b;
    }

    public String kMeansTipText() {
        return "Choose the clustering algorithm.";
    }

    public boolean getUseConstraints() {
        return this.useConstraints;
    }

    public void setUseConstraints(boolean b) {
        this.useConstraints = b;
    }

    public String useConstraintsTipText() {
        return "If activated constraints are used to limit each island to a local area.";
    }

    public boolean getReuseC() {
        this.reuseC = this.kMeans.getReuseC();
        return this.reuseC;
    }

    public void setReuseC(boolean m) {
        this.reuseC = m;
        this.kMeans.setReuseC(this.reuseC);
    }

    public String reuseCTipText() {
        return "Toggle reuse of previously found cluster centroids.";
    }
}

