/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.migration;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingAllDominating;
import eva2.optimization.operator.constraint.ConstObjectivesInEqualityBiggerThanLinear;
import eva2.optimization.operator.constraint.ConstObjectivesInEqualityBiggerThanSurface;
import eva2.optimization.operator.constraint.ConstObjectivesInEqualityLesserThanLinear;
import eva2.optimization.operator.constraint.ConstObjectivesInEqualitySmallerThanSurface;
import eva2.optimization.operator.constraint.InterfaceConstraint;
import eva2.optimization.operator.migration.InterfaceMigration;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconText;
import eva2.util.annotation.Description;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;

@Description(value="This is migration scheme, which implements a cone separation based partitioning.")
public class MOConeSeparation
implements InterfaceMigration,
Serializable {
    public boolean debug = false;
    private boolean useAllToDetermineR = false;
    private boolean useConstraints = true;
    private InterfaceSelection selection = new SelectRandom();
    private double[][] bounds3D;

    public MOConeSeparation() {
    }

    public MOConeSeparation(MOConeSeparation b) {
        this.debug = b.debug;
        this.useConstraints = b.useConstraints;
        this.useAllToDetermineR = b.useAllToDetermineR;
        if (b.selection != null) {
            this.selection = (InterfaceSelection)b.selection.clone();
        }
    }

    @Override
    public Object clone() {
        return new MOConeSeparation(this);
    }

    @Override
    public void initializeMigration(InterfaceOptimizer[] islands) {
    }

    @Override
    public void migrate(InterfaceOptimizer[] islands) {
        int i;
        Population[] oldIPOP = new Population[islands.length];
        Population[] newIPOP = new Population[islands.length];
        Population collector = new Population();
        ArchivingAllDominating allDom = new ArchivingAllDominating();
        for (i = 0; i < islands.length; ++i) {
            oldIPOP[i] = islands[i].getPopulation();
            if (this.debug) {
                System.out.println("Got population from " + i + " of size " + oldIPOP[i].size());
            }
            collector.addPopulation((Population)oldIPOP[i].clone());
            newIPOP[i] = new Population();
        }
        Population memory = (Population)collector.clone();
        if (((AbstractEAIndividual)collector.get(0)).getFitness().length == 2) {
            this.coneSeparation2D(collector, newIPOP, islands);
        } else if (((AbstractEAIndividual)collector.get(0)).getFitness().length == 3) {
            this.coneSeparation3D(collector, newIPOP, islands);
        } else if (((AbstractEAIndividual)collector.get(0)).getFitness().length >= 4) {
            System.out.println("*Pff*");
        }
        for (i = 0; i < islands.length; ++i) {
            oldIPOP[i].clear();
            oldIPOP[i].addPopulation(newIPOP[i]);
            if (!oldIPOP[i].targetSizeReached()) {
                oldIPOP[i].addPopulation(this.selection.selectFrom(memory, oldIPOP[i].getTargetSize() - oldIPOP[i].size()));
            }
            if (this.debug) {
                System.out.println("Setting island " + i + " to population size " + oldIPOP[i].size());
            }
            allDom.addElementsToArchive(oldIPOP[i]);
            islands[i].setPopulation(oldIPOP[i]);
        }
    }

    private void coneSeparation2D(Population collector, Population[] newIPOP, InterfaceOptimizer[] islands) {
        AbstractEAIndividual indy;
        int i;
        ArchivingAllDominating allDom = new ArchivingAllDominating();
        allDom.addElementsToArchive(collector);
        int y1Big = 0;
        int y2Big = 0;
        Population archive = collector.getArchive();
        Population ref = this.useAllToDetermineR ? collector : archive;
        for (int i2 = 1; i2 < ref.size(); ++i2) {
            if (((AbstractEAIndividual)ref.get(i2)).getFitness()[0] > ((AbstractEAIndividual)ref.get(y1Big)).getFitness()[0]) {
                y1Big = i2;
            }
            if (!(((AbstractEAIndividual)ref.get(i2)).getFitness()[1] > ((AbstractEAIndividual)ref.get(y2Big)).getFitness()[1])) continue;
            y2Big = i2;
        }
        double[] r = new double[2];
        double alpha = 90.0 / (double)islands.length;
        double[][] boundaries = new double[islands.length - 1][2];
        r[0] = ((AbstractEAIndividual)ref.get(y1Big)).getFitness()[0];
        r[1] = ((AbstractEAIndividual)ref.get(y2Big)).getFitness()[1];
        for (i = 0; i < boundaries.length; ++i) {
            boundaries[i][0] = 1.0 / Math.tan(Math.toRadians(alpha * (double)(i + 1)));
            boundaries[i][1] = r[1] - boundaries[i][0] * r[0];
        }
        collector.SetArchive(new Population());
        for (i = 0; i < boundaries.length; ++i) {
            for (int j = 0; j < collector.size(); ++j) {
                indy = (AbstractEAIndividual)collector.get(j);
                if (!(indy.getFitness()[1] < boundaries[i][0] * indy.getFitness()[0] + boundaries[i][1])) continue;
                newIPOP[i].add(indy);
                collector.remove(j);
                --j;
            }
        }
        newIPOP[newIPOP.length - 1].addPopulation(collector);
        if (this.debug) {
            DPoint myPoint;
            int i3;
            double[] tmpD = new double[]{0.0, 0.0};
            Plot plot = new Plot("Debugging Cone Separation", "Y1", "Y2", tmpD, tmpD);
            GraphPointSet mySet = new GraphPointSet(9, plot.getFunctionArea());
            mySet.setConnectedMode(false);
            for (i3 = 0; i3 < 250; ++i3) {
                myPoint = new DPoint(0.0, 0.0);
                mySet.addDPoint(myPoint);
            }
            for (i3 = 0; i3 < newIPOP.length; ++i3) {
                mySet = new GraphPointSet(10 + i3, plot.getFunctionArea());
                mySet.setConnectedMode(false);
                for (int j = 0; j < newIPOP[i3].size(); ++j) {
                    indy = (AbstractEAIndividual)newIPOP[i3].get(j);
                    myPoint = new DPoint(indy.getFitness()[0], indy.getFitness()[1]);
                    DPointIconText tmp = new DPointIconText("" + i3);
                    if (i3 % 2 == 0) {
                        tmp.setIcon(new DPointIconCircle());
                    }
                    myPoint.setIcon(tmp);
                    mySet.addDPoint(myPoint);
                }
            }
            mySet = new GraphPointSet(10, plot.getFunctionArea());
            mySet.setConnectedMode(false);
            for (i3 = 0; i3 < islands.length - 1; ++i3) {
                myPoint = new DPoint(r[0], r[1]);
                mySet.addDPoint(myPoint);
                myPoint = new DPoint(r[0], r[1]);
                mySet.addDPoint(myPoint);
                if (boundaries[i3][1] > 0.0) {
                    myPoint = new DPoint(0.0, boundaries[i3][1]);
                    mySet.addDPoint(myPoint);
                    myPoint = new DPoint(0.0, boundaries[i3][1]);
                    mySet.addDPoint(myPoint);
                    continue;
                }
                myPoint = new DPoint(-boundaries[i3][1] / boundaries[i3][0], 0.0);
                mySet.addDPoint(myPoint);
                myPoint = new DPoint(-boundaries[i3][1] / boundaries[i3][0], 0.0);
                mySet.addDPoint(myPoint);
            }
        }
        if (this.useConstraints) {
            for (int i4 = 0; i4 < islands.length; ++i4) {
                InterfaceConstraint b;
                InterfaceOptimizationProblem prob = islands[i4].getProblem();
                if (!(prob instanceof AbstractMultiObjectiveOptimizationProblem)) continue;
                ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.clear();
                if (i4 > 0) {
                    b = new ConstObjectivesInEqualityBiggerThanLinear(boundaries[i4 - 1][0], boundaries[i4 - 1][1]);
                    ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.add(b);
                }
                if (i4 < islands.length - 1) {
                    b = new ConstObjectivesInEqualityLesserThanLinear(boundaries[i4][0], boundaries[i4][1]);
                    ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.add(b);
                }
                islands[i4].setProblem(prob);
            }
        }
    }

    private void coneSeparation3D(Population collector, Population[] newIPOP, InterfaceOptimizer[] islands) {
        ArchivingAllDominating allDom = new ArchivingAllDominating();
        allDom.addElementsToArchive(collector);
        int y1Big = 0;
        int y2Big = 0;
        int y3Big = 0;
        Population archive = collector.getArchive();
        Population ref = this.useAllToDetermineR ? collector : archive;
        for (int i = 1; i < ref.size(); ++i) {
            if (((AbstractEAIndividual)ref.get(i)).getFitness()[0] > ((AbstractEAIndividual)ref.get(y1Big)).getFitness()[0]) {
                y1Big = i;
            }
            if (((AbstractEAIndividual)ref.get(i)).getFitness()[1] > ((AbstractEAIndividual)ref.get(y2Big)).getFitness()[1]) {
                y2Big = i;
            }
            if (!(((AbstractEAIndividual)ref.get(i)).getFitness()[2] > ((AbstractEAIndividual)ref.get(y3Big)).getFitness()[2])) continue;
            y3Big = i;
        }
        double[] distopian = new double[3];
        double[] zE = new double[3];
        double[][] normals = new double[islands.length][3];
        double angIncr = 360.0 / (double)islands.length;
        distopian[0] = ((AbstractEAIndividual)ref.get(y1Big)).getFitness()[0];
        distopian[1] = ((AbstractEAIndividual)ref.get(y2Big)).getFitness()[1];
        distopian[2] = ((AbstractEAIndividual)ref.get(y3Big)).getFitness()[2];
        zE[0] = 0.0;
        zE[1] = 0.0;
        zE[2] = 1.0;
        double[] firstVec = this.getCrossProduct(distopian, zE);
        firstVec = this.getNormalized(firstVec);
        double[] normDist = this.getNormalized(distopian);
        this.bounds3D = new double[normals.length + 2][3];
        this.bounds3D[0] = distopian;
        for (int i = 0; i < normals.length; ++i) {
            normals[i] = this.rotVector(firstVec, normDist, Math.toRadians((double)i * angIncr));
            this.bounds3D[i + 1] = normals[i];
        }
        double[][] lastBoundingPlane = new double[2][3];
        double[][] curBoundingPlane = new double[2][3];
        lastBoundingPlane[0] = distopian;
        lastBoundingPlane[1] = normals[normals.length - 1];
        curBoundingPlane[0] = distopian;
        curBoundingPlane[1] = normals[0];
        collector.SetArchive(new Population());
        for (int i = 0; i < normals.length; ++i) {
            for (int j = 0; j < collector.size(); ++j) {
                AbstractEAIndividual indy = (AbstractEAIndividual)collector.get(j);
                double[] fitness = indy.getFitness();
                if (!(this.getScalarProduct(curBoundingPlane[1], this.getVectorSub(fitness, curBoundingPlane[0])) < 0.0) || !(this.getScalarProduct(lastBoundingPlane[1], this.getVectorSub(fitness, lastBoundingPlane[0])) >= 0.0)) continue;
                newIPOP[i].add(indy);
            }
            if (this.useConstraints) {
                InterfaceOptimizationProblem prob = islands[i].getProblem();
                if (prob instanceof AbstractMultiObjectiveOptimizationProblem) {
                    ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.clear();
                    ConstObjectivesInEqualitySmallerThanSurface sts = new ConstObjectivesInEqualitySmallerThanSurface(curBoundingPlane[0], curBoundingPlane[1]);
                    ConstObjectivesInEqualityBiggerThanSurface bts = new ConstObjectivesInEqualityBiggerThanSurface(lastBoundingPlane[0], lastBoundingPlane[1]);
                    ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.add(sts);
                    ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.add(bts);
                }
                islands[i].setProblem(prob);
            }
            lastBoundingPlane[0] = curBoundingPlane[0];
            lastBoundingPlane[1] = curBoundingPlane[1];
            curBoundingPlane[0] = distopian;
            if (i + 1 >= normals.length) continue;
            curBoundingPlane[1] = normals[i + 1];
        }
    }

    private double getScalarProduct(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    private double[] getCrossProduct(double[] a, double[] b) {
        double[] result = new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        return result;
    }

    private double[] getVectorAdd(double[] a, double[] b) {
        double[] result = new double[]{a[0] + b[0], a[1] + b[1], a[2] + b[2]};
        return result;
    }

    private double[] getVectorSub(double[] a, double[] b) {
        double[] result = new double[]{a[0] - b[0], a[1] - b[1], a[2] - b[2]};
        return result;
    }

    private double[] getScalarMultiplication(double a, double[] b) {
        double[] result = new double[]{a * b[0], a * b[1], a * b[2]};
        return result;
    }

    private double[] getNormalized(double[] a) {
        int i;
        double[] result = new double[a.length];
        double sum = 0.0;
        for (i = 0; i < a.length; ++i) {
            sum += Math.pow(a[i], 2.0);
        }
        sum = Math.sqrt(sum);
        for (i = 0; i < a.length; ++i) {
            result[i] = a[i] / sum;
        }
        return result;
    }

    private double[] qMult(double[] s, double[] v) {
        double[] r = new double[]{s[0] * v[0] - s[1] * v[1] - s[2] * v[2] - s[3] * v[3], s[0] * v[1] + s[1] * v[0] + s[2] * v[3] - s[3] * v[2], s[0] * v[2] - s[1] * v[3] + s[2] * v[0] + s[3] * v[1], s[0] * v[3] + s[1] * v[2] - s[2] * v[1] + s[3] * v[0]};
        return r;
    }

    private double[] rotQuad(double[] v, double[] u, double alpha) {
        double[] result = new double[3];
        double[] q = new double[4];
        double[] qt = new double[4];
        double[] p = new double[]{0.0, v[0], v[1], v[2]};
        double s = Math.cos(alpha / 2.0);
        double f = Math.sin(alpha / 2.0);
        q[0] = s;
        q[1] = u[0] * f;
        q[2] = u[1] * f;
        q[3] = u[2] * f;
        qt[0] = s;
        qt[1] = -q[1];
        qt[2] = -q[2];
        qt[3] = -q[3];
        p = this.qMult(q, p);
        p = this.qMult(p, qt);
        f = 1.0 / (q[0] * q[0] + q[1] * q[1] + q[2] * q[2] + q[3] * q[3]);
        result[0] = p[1];
        result[1] = p[2];
        result[2] = p[3];
        result = this.getNormalized(result);
        return result;
    }

    private double[] rotVector(double[] p, double[] w, double a) {
        double[] tmp1 = this.getScalarMultiplication(Math.cos(a), p);
        double[] tmp2 = this.getScalarMultiplication(this.getScalarProduct(w, p), p);
        tmp2 = this.getScalarMultiplication(1.0 - Math.cos(a), tmp2);
        double[] tmp3 = this.getScalarMultiplication(Math.sin(a), this.getCrossProduct(w, p));
        double[] result = this.getVectorAdd(tmp1, tmp2);
        result = this.getVectorAdd(result, tmp3);
        return result;
    }

    private void writeToFile(BufferedWriter out, String line) {
        String write = line + "\n";
        write.replaceAll(",", ".");
        if (out == null) {
            return;
        }
        try {
            out.write(write, 0, write.length());
            out.flush();
        }
        catch (IOException e) {
            System.out.println("Problems writing to output file!");
        }
    }

    public String getName() {
        return "MOConeSeparation";
    }

    public boolean getUseAllToDetermineR() {
        return this.useAllToDetermineR;
    }

    public void setUseAllToDetermineR(boolean b) {
        this.useAllToDetermineR = b;
    }

    public String useAllToDetermineRTipText() {
        return "If true all individuals are used to calculate the reference point (may reduce efficiency).";
    }

    public boolean getUseConstraints() {
        return this.useConstraints;
    }

    public void setUseConstraints(boolean b) {
        this.useConstraints = b;
    }

    public String useConstraintsTipText() {
        return "If activated constraints are used to limit each island to a local area.";
    }
}

