/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.migration;

import eva2.gui.plot.GraphPointSet;
import eva2.gui.plot.Plot;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.archiving.ArchivingNSGAII;
import eva2.optimization.operator.cluster.ClusteringXMeans;
import eva2.optimization.operator.constraint.ConstBelongsToDifferentClass;
import eva2.optimization.operator.migration.InterfaceMigration;
import eva2.optimization.operator.selection.InterfaceSelection;
import eva2.optimization.operator.selection.SelectRandom;
import eva2.optimization.population.Population;
import eva2.optimization.strategies.InterfaceOptimizer;
import eva2.problems.AbstractMultiObjectiveOptimizationProblem;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.chart2d.DPoint;
import eva2.tools.chart2d.DPointIconCircle;
import eva2.tools.chart2d.DPointIconText;
import eva2.util.annotation.Description;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;

@Description(value="This is migration scheme, which implements a clustering based partitioning.")
public class MOXMeansSeparation
implements InterfaceMigration,
Serializable {
    public boolean debug = false;
    private ClusteringXMeans xMeans = new ClusteringXMeans();
    private ArchivingNSGAII NSGAII = new ArchivingNSGAII();
    private boolean useConstraints = true;
    private InterfaceSelection selection = new SelectRandom();

    public MOXMeansSeparation() {
    }

    public MOXMeansSeparation(MOXMeansSeparation b) {
        this.debug = b.debug;
        this.useConstraints = b.useConstraints;
        if (b.xMeans != null) {
            this.xMeans = (ClusteringXMeans)b.xMeans.clone();
        }
        if (b.NSGAII != null) {
            this.NSGAII = (ArchivingNSGAII)b.NSGAII.clone();
        }
        if (b.selection != null) {
            this.selection = (InterfaceSelection)b.selection.clone();
        }
    }

    @Override
    public Object clone() {
        return new MOXMeansSeparation(this);
    }

    @Override
    public void initializeMigration(InterfaceOptimizer[] islands) {
    }

    @Override
    public void migrate(InterfaceOptimizer[] islands) {
        int i;
        Population[] oldIPOP = new Population[islands.length];
        Population[] newIPOP = new Population[islands.length];
        Population collector = new Population();
        for (int i2 = 0; i2 < islands.length; ++i2) {
            oldIPOP[i2] = islands[i2].getPopulation();
            if (this.debug) {
                System.out.println("Got population from " + i2 + " of size " + oldIPOP[i2].size());
            }
            collector.addPopulation((Population)oldIPOP[i2].clone());
            newIPOP[i2] = new Population();
        }
        Population memory = (Population)collector.clone();
        Population[] archives = this.NSGAII.getNonDominatedSortedFronts(collector);
        Population toCluster = new Population();
        int currentFront = 0;
        toCluster.addPopulation(archives[currentFront]);
        while (toCluster.size() < islands.length) {
            toCluster.addPopulation(archives[++currentFront]);
        }
        this.xMeans.setMaxK(islands.length);
        this.xMeans.cluster(toCluster, (Population)null);
        double[][] c = this.xMeans.getC();
        newIPOP = this.xMeans.cluster(collector, c);
        for (i = 0; i < islands.length; ++i) {
            islands[i].getPopulation().clear();
            islands[i].getPopulation().setTargetSize(0);
        }
        if (this.debug) {
            DPointIconText tmp;
            DPoint myPoint;
            GraphPointSet mySet;
            int i3;
            double[] tmpD = new double[]{0.0, 0.0};
            Plot plot = new Plot("Debugging Clustering Separation", "Y1", "Y2", tmpD, tmpD);
            for (i3 = 0; i3 < newIPOP.length; ++i3) {
                mySet = new GraphPointSet(11, plot.getFunctionArea());
                mySet.setConnectedMode(false);
                for (int j = 0; j < newIPOP[i3].size(); ++j) {
                    AbstractEAIndividual indy = (AbstractEAIndividual)newIPOP[i3].get(j);
                    myPoint = new DPoint(indy.getFitness()[0], indy.getFitness()[1]);
                    tmp = new DPointIconText("" + i3);
                    myPoint.setIcon(tmp);
                    mySet.addDPoint(myPoint);
                }
            }
            mySet = new GraphPointSet(12, plot.getFunctionArea());
            mySet.setConnectedMode(false);
            for (i3 = 0; i3 < c.length; ++i3) {
                myPoint = new DPoint(c[i3][0], c[i3][1]);
                tmp = new DPointIconText("" + i3);
                tmp.setIcon(new DPointIconCircle());
                myPoint.setIcon(tmp);
                mySet.addDPoint(myPoint);
            }
        }
        if (this.useConstraints && c.length > 1) {
            for (int i4 = 0; i4 < islands.length && i4 < c.length; ++i4) {
                InterfaceOptimizationProblem prob = islands[i4].getProblem();
                if (!(prob instanceof AbstractMultiObjectiveOptimizationProblem)) continue;
                ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.clear();
                double[] myClass = c[i4];
                double[][] myOtherClass = new double[c.length - 1][];
                int index = 0;
                for (int j = 0; j < myOtherClass.length; ++j) {
                    if (index == i4) {
                        ++index;
                    }
                    myOtherClass[j] = c[index];
                    ++index;
                }
                ConstBelongsToDifferentClass b = new ConstBelongsToDifferentClass(myClass, myOtherClass, this.xMeans.getUseSearchSpace());
                ((AbstractMultiObjectiveOptimizationProblem)prob).areaConst4Parallelization.add(b);
                islands[i4].setProblem(prob);
            }
        }
        for (i = 0; i < islands.length && i < newIPOP.length; ++i) {
            oldIPOP[i].clear();
            oldIPOP[i].addPopulation(newIPOP[i]);
            if (!oldIPOP[i].targetSizeReached()) {
                oldIPOP[i].addPopulation(this.selection.selectFrom(memory, oldIPOP[i].getFreeSlots()));
            }
            if (this.debug) {
                System.out.println("Setting " + i + " to population size " + oldIPOP[i].size());
            }
            islands[i].setPopulation(oldIPOP[i]);
            islands[i].getPopulation().setTargetSize(oldIPOP[i].size());
        }
    }

    private void writeToFile(BufferedWriter out, String line) {
        String write = line + "\n";
        write.replaceAll(",", ".");
        if (out == null) {
            return;
        }
        try {
            out.write(write, 0, write.length());
            out.flush();
        }
        catch (IOException e) {
            System.out.println("Problems writing to output file!");
        }
    }

    public String getName() {
        return "MOClusteringSeparation";
    }

    public ClusteringXMeans getXMeans() {
        return this.xMeans;
    }

    public void setXMeans(ClusteringXMeans b) {
        this.xMeans = b;
    }

    public String xMeansTipText() {
        return "Parameterize the clustering algorithm.";
    }

    public boolean getUseConstraints() {
        return this.useConstraints;
    }

    public void setUseConstraints(boolean b) {
        this.useConstraints = b;
    }

    public String useConstraintsTipText() {
        return "If activated constraints are used to limit each island to a local area.";
    }
}

