/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method calcuates a dynamic weighted sum over TWO fitness values depending on the current generation.")
public class MOSODynamicallyWeightedFitness
implements InterfaceMOSOConverter,
Serializable {
    private double f = 50.0;
    private int currentGeneration = 0;
    private int outputDimension = 2;

    public MOSODynamicallyWeightedFitness() {
    }

    public MOSODynamicallyWeightedFitness(MOSODynamicallyWeightedFitness b) {
        this.currentGeneration = b.currentGeneration;
        this.f = b.f;
        this.outputDimension = b.outputDimension;
    }

    @Override
    public Object clone() {
        return new MOSODynamicallyWeightedFitness(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        this.currentGeneration = pop.getGeneration();
        for (int i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        double[] weights = new double[tmpFit.length];
        weights[0] = Math.pow(Math.sin(Math.PI * 2 * (double)this.currentGeneration / this.f), 2.0);
        weights[1] = 1.0 - weights[0];
        for (int i = 0; i < 2 && i < tmpFit.length; ++i) {
            resultFit[0] = resultFit[0] + tmpFit[i] * weights[i];
        }
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
        this.outputDimension = dim;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName() + "\n";
    }

    @Override
    public String getName() {
        return "Dynamic Weighted Sum";
    }

    public void setF(double f) {
        this.f = f;
    }

    public double getF() {
        return this.f;
    }

    public String fTipText() {
        return "Choose the frequency for the fitness value.";
    }
}

