/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.gui.PropertyEpsilonConstraint;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method uses n-1 objected as hard constraints.")
public class MOSOEpsilonConstraint
implements InterfaceMOSOConverter,
Serializable {
    private PropertyEpsilonConstraint epsilonConstraint = null;

    public MOSOEpsilonConstraint() {
        this.epsilonConstraint = new PropertyEpsilonConstraint();
        this.epsilonConstraint.optimizeObjective = 0;
        double[] tmpD = new double[2];
        for (int i = 0; i < tmpD.length; ++i) {
            tmpD[i] = 0.0;
        }
        this.epsilonConstraint.targetValue = tmpD;
    }

    public MOSOEpsilonConstraint(MOSOEpsilonConstraint b) {
        if (b.epsilonConstraint != null) {
            this.epsilonConstraint = (PropertyEpsilonConstraint)b.epsilonConstraint.clone();
        }
    }

    @Override
    public Object clone() {
        return new MOSOEpsilonConstraint(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        resultFit[0] = tmpFit[this.epsilonConstraint.optimizeObjective];
        for (int i = 0; i < this.epsilonConstraint.targetValue.length; ++i) {
            if (i == this.epsilonConstraint.optimizeObjective) continue;
            indy.addConstraintViolation(Math.max(0.0, tmpFit[i] - this.epsilonConstraint.targetValue[i]));
        }
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
        int i;
        double[] newTarget = new double[dim];
        for (i = 0; i < newTarget.length; ++i) {
            newTarget[i] = 0.0;
        }
        for (i = 0; i < this.epsilonConstraint.targetValue.length && i < newTarget.length; ++i) {
            newTarget[i] = this.epsilonConstraint.targetValue[i];
        }
        if (this.epsilonConstraint.optimizeObjective >= dim) {
            this.epsilonConstraint.optimizeObjective = dim - 1;
        }
        this.epsilonConstraint.targetValue = newTarget;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName() + "\n";
    }

    @Override
    public String getName() {
        return "Epsilon Constraint";
    }

    public void setEpsilonThreshhold(PropertyEpsilonConstraint weights) {
        this.epsilonConstraint = weights;
    }

    public PropertyEpsilonConstraint getEpsilonThreshhold() {
        return this.epsilonConstraint;
    }

    public String epsilonThreshholdTipText() {
        return "Choose the epsilon constraints for the fitness sum.";
    }
}

