/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.gui.PropertyEpsilonThreshold;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method uses n-1 objected as soft constraints.")
public class MOSOEpsilonThreshold
implements InterfaceMOSOConverter,
Serializable {
    private PropertyEpsilonThreshold epsilonThreshold = null;

    public MOSOEpsilonThreshold() {
        int i;
        this.epsilonThreshold = new PropertyEpsilonThreshold();
        this.epsilonThreshold.optimizeObjective = 0;
        double[] tmpD = new double[2];
        for (i = 0; i < tmpD.length; ++i) {
            tmpD[i] = 0.0;
        }
        this.epsilonThreshold.targetValue = tmpD;
        tmpD = new double[2];
        for (i = 0; i < tmpD.length; ++i) {
            tmpD[i] = 1.0;
        }
        this.epsilonThreshold.punishment = tmpD;
    }

    public MOSOEpsilonThreshold(MOSOEpsilonThreshold b) {
        if (b.epsilonThreshold != null) {
            this.epsilonThreshold = (PropertyEpsilonThreshold)b.epsilonThreshold.clone();
        }
    }

    @Override
    public Object clone() {
        return new MOSOEpsilonThreshold(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        int i;
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        for (i = 0; i < tmpFit.length; ++i) {
            if (new Double(tmpFit[i]).isNaN()) {
                System.out.println("Fitness is NaN");
            }
            if (!new Double(tmpFit[i]).isInfinite()) continue;
            System.out.println("Fitness is Infinite");
        }
        resultFit[0] = tmpFit[this.epsilonThreshold.optimizeObjective];
        for (i = 0; i < this.epsilonThreshold.punishment.length; ++i) {
            if (i == this.epsilonThreshold.optimizeObjective) continue;
            resultFit[0] = resultFit[0] + this.epsilonThreshold.punishment[i] * Math.max(0.0, tmpFit[i] - this.epsilonThreshold.targetValue[i]);
        }
        tmpFit = (double[])indy.getData("MOFitness");
        for (i = 0; i < tmpFit.length; ++i) {
            if (new Double(tmpFit[i]).isNaN()) {
                System.out.println("-Fitness is NaN");
            }
            if (!new Double(tmpFit[i]).isInfinite()) continue;
            System.out.println("-Fitness is Infinite");
        }
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
        int i;
        double[] newPunish = new double[dim];
        double[] newTarget = new double[dim];
        for (i = 0; i < newPunish.length; ++i) {
            newPunish[i] = 1.0;
            newTarget[i] = 0.0;
        }
        for (i = 0; i < this.epsilonThreshold.punishment.length && i < newTarget.length; ++i) {
            newPunish[i] = this.epsilonThreshold.punishment[i];
            newTarget[i] = this.epsilonThreshold.targetValue[i];
        }
        if (this.epsilonThreshold.optimizeObjective >= dim) {
            this.epsilonThreshold.optimizeObjective = dim - 1;
        }
        this.epsilonThreshold.punishment = newPunish;
        this.epsilonThreshold.targetValue = newTarget;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName() + "\n";
    }

    @Override
    public String getName() {
        return "Epsilon Threshold";
    }

    public void setEpsilonThreshhold(PropertyEpsilonThreshold weights) {
        this.epsilonThreshold = weights;
    }

    public PropertyEpsilonThreshold getEpsilonThreshhold() {
        return this.epsilonThreshold;
    }

    public String epsilonThreshholdTipText() {
        return "Choose the epsilon thresholds for the fitness sum.";
    }
}

