/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.gui.PropertyDoubleArray;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method minimizes the delta to a given target fitness values.")
public class MOSOGoalProgramming
implements InterfaceMOSOConverter,
Serializable {
    private PropertyDoubleArray goals = null;

    public MOSOGoalProgramming() {
        double[] tmpD = new double[2];
        for (int i = 0; i < tmpD.length; ++i) {
            tmpD[i] = 0.0;
        }
        this.goals = new PropertyDoubleArray(tmpD);
    }

    public MOSOGoalProgramming(MOSOGoalProgramming b) {
        if (b.goals != null) {
            this.goals = b.goals;
        }
    }

    @Override
    public Object clone() {
        return new MOSOGoalProgramming(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        resultFit[0] = 0.0;
        for (int i = 0; i < this.goals.getNumRows() && i < tmpFit.length; ++i) {
            resultFit[0] = resultFit[0] + (tmpFit[i] - this.goals.getValue(i, 0));
        }
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
        int i;
        double[] newWeights = new double[dim];
        for (i = 0; i < newWeights.length; ++i) {
            newWeights[i] = 0.0;
        }
        for (i = 0; i < this.goals.getNumRows() && i < newWeights.length; ++i) {
            newWeights[i] = this.goals.getValue(i, 0);
        }
        this.goals.setDoubleArray(newWeights);
    }

    @Override
    public String getStringRepresentation() {
        return this.getName() + "\n";
    }

    @Override
    public String getName() {
        return "Goal Programming";
    }

    public void setGoals(PropertyDoubleArray goals) {
        this.goals = goals;
    }

    public PropertyDoubleArray getGoals() {
        return this.goals;
    }

    public String goalsTipText() {
        return "Choose the goals for the fitness values.";
    }
}

