/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.gui.PropertyDoubleArray;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method minimizes the Lp metric to a given target fitness values, for (p<1) this equals the Tchebycheff metric.")
public class MOSOLpMetric
implements InterfaceMOSOConverter,
Serializable {
    private PropertyDoubleArray reference = null;
    private int p = 2;

    public MOSOLpMetric() {
        double[] tmpD = new double[2];
        for (int i = 0; i < tmpD.length; ++i) {
            tmpD[i] = 0.0;
        }
        this.reference = new PropertyDoubleArray(tmpD);
    }

    public MOSOLpMetric(MOSOLpMetric b) {
        this.p = b.p;
        if (b.reference != null) {
            this.reference = (PropertyDoubleArray)b.reference.clone();
        }
    }

    @Override
    public Object clone() {
        return new MOSOLpMetric(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        if (this.p >= 1) {
            resultFit[0] = 0.0;
            for (int i = 0; i < this.reference.getNumRows() && i < tmpFit.length; ++i) {
                resultFit[0] = resultFit[0] + Math.pow(Math.abs(tmpFit[i] - this.reference.getValue(i, 0)), this.p);
            }
            resultFit[0] = Math.pow(resultFit[0], 1.0 / (double)this.p);
        } else {
            resultFit[0] = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < this.reference.getNumRows() && i < tmpFit.length; ++i) {
                resultFit[0] = resultFit[0] + Math.max(Math.abs(tmpFit[i] - this.reference.getValue(i, 0)), resultFit[0]);
            }
        }
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
        int i;
        double[] newWeights = new double[dim];
        for (i = 0; i < newWeights.length; ++i) {
            newWeights[i] = 0.0;
        }
        for (i = 0; i < this.reference.getNumRows() && i < newWeights.length; ++i) {
            newWeights[i] = this.reference.getValue(i, 0);
        }
        this.reference.setDoubleArray(newWeights);
    }

    @Override
    public String getStringRepresentation() {
        String result = "Lp Metric\n";
        result = result + " P           = " + this.p + "\n";
        result = result + " Ref.Fitness = (";
        for (int i = 0; i < this.reference.getNumRows(); ++i) {
            result = result + this.reference.getValue(i, 0);
            if (i >= this.reference.getNumRows() - 1) continue;
            result = result + "; ";
        }
        result = result + ")\n";
        return result;
    }

    @Override
    public String getName() {
        return "Lp Metric";
    }

    public void setReference(PropertyDoubleArray reference) {
        this.reference = reference;
    }

    public PropertyDoubleArray getReference() {
        return this.reference;
    }

    public String referenceTipText() {
        return "Choose the reference for the fitness values.";
    }

    public void setP(int p) {
        this.p = Math.max(1, p);
    }

    public int getP() {
        return this.p;
    }

    public String pTipText() {
        return "Choose the exponent p for the Lp metric, if (p<1) this results in the Tchebycheff metric.";
    }
}

