/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method calculates the MOGA rank of each individual and uses the rank as fitness [Fonseca93Genetic].")
public class MOSOMOGARankBased
implements InterfaceMOSOConverter,
Serializable {
    public MOSOMOGARankBased() {
    }

    public MOSOMOGARankBased(MOSOMOGARankBased b) {
    }

    @Override
    public Object clone() {
        return new MOSOMOGARankBased(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        int i;
        int[] MOGARank = new int[pop.size()];
        for (i = 0; i < MOGARank.length; ++i) {
            MOGARank[i] = 1;
        }
        for (i = 0; i < pop.size() - 1; ++i) {
            for (int j = 0; j < pop.size(); ++j) {
                if (i == j || !((AbstractEAIndividual)pop.get(j)).isDominatingDebConstraints((AbstractEAIndividual)pop.get(i))) continue;
                int n = i;
                MOGARank[n] = MOGARank[n] + 1;
            }
        }
        for (i = 0; i < pop.size(); ++i) {
            ((AbstractEAIndividual)pop.get(i)).putData("MOGARank", MOGARank[i]);
        }
        for (i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        resultFit[0] = ((Integer)indy.getData("MOGARank")).doubleValue();
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
    }

    @Override
    public String getStringRepresentation() {
        return this.getName() + "\n";
    }

    @Override
    public String getName() {
        return "MOGA Rank Based";
    }
}

