/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method calculate the maximum of minimum distance over all criterias over all individuals.")
public class MOSOMaxiMin
implements InterfaceMOSOConverter,
Serializable {
    private int outputDimension = 2;

    public MOSOMaxiMin() {
    }

    public MOSOMaxiMin(MOSOMaxiMin b) {
        this.outputDimension = b.outputDimension;
    }

    @Override
    public Object clone() {
        return new MOSOMaxiMin(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        int i;
        AbstractEAIndividual tmpIndy = (AbstractEAIndividual)pop.get(0);
        double[][] fitnessArray = new double[pop.size()][tmpIndy.getFitness().length];
        double[][] minArray = new double[pop.size()][tmpIndy.getFitness().length];
        double[] result = new double[pop.size()];
        double[] resultFit = new double[1];
        for (i = 0; i < pop.size(); ++i) {
            fitnessArray[i] = ((AbstractEAIndividual)pop.get(i)).getFitness();
        }
        for (i = 0; i < fitnessArray.length; ++i) {
            result[i] = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < fitnessArray.length; ++k) {
                if (i == k) continue;
                double tmpResult = Double.POSITIVE_INFINITY;
                for (int j = 0; j < fitnessArray[k].length; ++j) {
                    tmpResult = Math.min(tmpResult, fitnessArray[i][j] - fitnessArray[k][j]);
                }
                result[i] = Math.max(result[i], tmpResult);
            }
            tmpIndy = (AbstractEAIndividual)pop.get(i);
            double[] tmpFit = tmpIndy.getFitness();
            tmpIndy.putData("MOFitness", tmpFit);
            resultFit = new double[]{result[i]};
            tmpIndy.setFitness(resultFit);
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        System.err.println("The MaxiMin MOSO can not be applied to single individuals! I default to random criterion.");
        resultFit[0] = tmpFit[RNG.randomInt(0, tmpFit.length)];
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
        this.outputDimension = dim;
    }

    @Override
    public String getStringRepresentation() {
        return this.getName() + "\n";
    }

    @Override
    public String getName() {
        return "MaxiMin Criterium";
    }
}

