/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method calcuates a randomly weighted sum over all fitness values [Murata95MOGA].")
public class MOSORandomWeight
implements InterfaceMOSOConverter,
Serializable {
    public MOSORandomWeight() {
    }

    public MOSORandomWeight(MOSORandomWeight b) {
    }

    @Override
    public Object clone() {
        return new MOSORandomWeight(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        int i;
        double[] resultFit = new double[1];
        double sum = 0.0;
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        double[] tmpWeight = new double[tmpFit.length];
        for (i = 0; i < tmpWeight.length; ++i) {
            tmpWeight[i] = RNG.randomDouble(0.0, 1.0);
            sum += tmpWeight[i];
        }
        if (sum <= 1.0E-7) {
            for (i = 0; i < tmpWeight.length; ++i) {
                tmpWeight[i] = 1.0 / (double)tmpWeight.length;
            }
        } else {
            i = 0;
            while (i < tmpWeight.length) {
                int n = i++;
                tmpWeight[n] = tmpWeight[n] / sum;
            }
        }
        for (i = 0; i < tmpWeight.length && i < tmpFit.length; ++i) {
            resultFit[0] = resultFit[0] + tmpFit[i] * tmpWeight[i];
        }
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
    }

    @Override
    public String getStringRepresentation() {
        return this.getName() + "\n";
    }

    @Override
    public String getName() {
        return "Randomly Weighted Sum";
    }
}

