/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.gui.PropertyDoubleArray;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method calcuates the weighted sum over all fitness values.")
public class MOSOWeightedFitness
implements InterfaceMOSOConverter,
Serializable {
    private PropertyDoubleArray weights = null;

    public MOSOWeightedFitness() {
        int i;
        double[][] tmpD = new double[2][1];
        for (i = 0; i < tmpD.length; ++i) {
            tmpD[i][0] = 1.0;
        }
        this.weights = new PropertyDoubleArray(tmpD);
        for (i = 0; i < this.weights.getNumRows(); ++i) {
            this.weights.normalizeColumns();
        }
    }

    public MOSOWeightedFitness(double[][] weights) {
        this();
        this.setWeights(new PropertyDoubleArray(weights));
    }

    public MOSOWeightedFitness(MOSOWeightedFitness b) {
        if (b.weights != null) {
            this.weights = b.weights;
        }
    }

    @Override
    public Object clone() {
        return new MOSOWeightedFitness(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        for (int i = 0; i < this.weights.getNumRows() && i < tmpFit.length; ++i) {
            resultFit[0] = resultFit[0] + tmpFit[i] * this.weights.getValue(i, 0);
        }
        indy.setFitness(resultFit);
    }

    private void checkingWeights() {
        String s = "Using Weights: {";
        for (int i = 0; i < this.weights.getNumRows(); ++i) {
            s = s + this.weights.getValue(i, 0);
            if (i >= this.weights.getNumRows() - 1) continue;
            s = s + "; ";
        }
        System.out.println(s + "}");
    }

    @Override
    public void setOutputDimension(int dim) {
        int i;
        double[] newWeights = new double[dim];
        for (i = 0; i < newWeights.length; ++i) {
            newWeights[i] = 1.0;
        }
        for (i = 0; i < this.weights.getNumRows() && i < newWeights.length; ++i) {
            newWeights[i] = this.weights.getValue(i, 0);
        }
        this.weights.setDoubleArray(newWeights);
    }

    @Override
    public String getStringRepresentation() {
        return this.getName() + "\n";
    }

    @Override
    public String getName() {
        return "Weighted Sum";
    }

    public void setWeights(PropertyDoubleArray weights) {
        this.weights = weights;
    }

    public PropertyDoubleArray getWeights() {
        return this.weights;
    }

    public String weightsTipText() {
        return "Choose the weights for the fitness values.";
    }
}

