/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.moso;

import eva2.gui.PropertyWeightedLPTchebycheff;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.moso.InterfaceMOSOConverter;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This method implements the Lp-problem and the Tchebycheff metric, the weighted version is also known as compromise programming.")
public class MOSOWeightedLPTchebycheff
implements InterfaceMOSOConverter,
Serializable {
    private PropertyWeightedLPTchebycheff weightedLPTchebycheff = null;

    public MOSOWeightedLPTchebycheff() {
        int i;
        this.weightedLPTchebycheff = new PropertyWeightedLPTchebycheff();
        this.weightedLPTchebycheff.p = 0;
        double[] tmpD = new double[2];
        for (i = 0; i < tmpD.length; ++i) {
            tmpD[i] = 0.0;
        }
        this.weightedLPTchebycheff.idealValue = tmpD;
        tmpD = new double[2];
        for (i = 0; i < tmpD.length; ++i) {
            tmpD[i] = 1.0;
        }
        this.weightedLPTchebycheff.weights = tmpD;
    }

    public MOSOWeightedLPTchebycheff(MOSOWeightedLPTchebycheff b) {
        if (b.weightedLPTchebycheff != null) {
            this.weightedLPTchebycheff = (PropertyWeightedLPTchebycheff)b.weightedLPTchebycheff.clone();
        }
    }

    @Override
    public Object clone() {
        return new MOSOWeightedLPTchebycheff(this);
    }

    @Override
    public void convertMultiObjective2SingleObjective(Population pop) {
        for (int i = 0; i < pop.size(); ++i) {
            this.convertSingleIndividual((AbstractEAIndividual)pop.get(i));
        }
    }

    @Override
    public void convertSingleIndividual(AbstractEAIndividual indy) {
        double[] resultFit = new double[1];
        double[] tmpFit = indy.getFitness();
        indy.putData("MOFitness", tmpFit);
        resultFit[0] = 0.0;
        for (int i = 0; i < tmpFit.length; ++i) {
            resultFit[0] = this.weightedLPTchebycheff.p == 0 ? Math.max(resultFit[0], this.weightedLPTchebycheff.weights[i] * Math.abs(tmpFit[i] - this.weightedLPTchebycheff.idealValue[i])) : resultFit[0] + this.weightedLPTchebycheff.weights[i] * Math.pow(tmpFit[i] - this.weightedLPTchebycheff.idealValue[i], this.weightedLPTchebycheff.p);
        }
        if (this.weightedLPTchebycheff.p > 0) {
            resultFit[0] = Math.pow(resultFit[0], 1.0 / (double)this.weightedLPTchebycheff.p);
        }
        indy.setFitness(resultFit);
    }

    @Override
    public void setOutputDimension(int dim) {
        int i;
        double[] newTarget = new double[dim];
        double[] newWeights = new double[dim];
        for (i = 0; i < newTarget.length; ++i) {
            newTarget[i] = 0.0;
            newWeights[i] = 1.0;
        }
        for (i = 0; i < this.weightedLPTchebycheff.idealValue.length && i < newTarget.length; ++i) {
            newTarget[i] = this.weightedLPTchebycheff.idealValue[i];
            newWeights[i] = this.weightedLPTchebycheff.weights[i];
        }
        this.weightedLPTchebycheff.idealValue = newTarget;
        this.weightedLPTchebycheff.weights = newWeights;
    }

    @Override
    public String getStringRepresentation() {
        int i;
        String result = "Lp Metric\n";
        result = result + " P           = " + this.weightedLPTchebycheff.p + "\n";
        result = result + " Ref.Fitness = (";
        double[] p = this.weightedLPTchebycheff.idealValue;
        for (i = 0; i < p.length; ++i) {
            result = result + p[i];
            if (i >= p.length - 1) continue;
            result = result + "; ";
        }
        result = result + ")\n";
        result = result + " Weights     = (";
        p = this.weightedLPTchebycheff.weights;
        for (i = 0; i < p.length; ++i) {
            result = result + p[i];
            if (i >= p.length - 1) continue;
            result = result + "; ";
        }
        result = result + ")\n";
        return result;
    }

    @Override
    public String getName() {
        return "Lp/Tchebycheff";
    }

    public void setIdealPWeights(PropertyWeightedLPTchebycheff weights) {
        this.weightedLPTchebycheff = weights;
    }

    public PropertyWeightedLPTchebycheff getIdealPWeights() {
        return this.weightedLPTchebycheff;
    }

    public String idealPWeightsTipText() {
        return "Set the ideal vector, the weights and p (note: p=0 equals Tchebycheff metric).";
    }
}

