/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import Jama.Matrix;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.population.InterfacePopulationChangedEventListener;
import eva2.optimization.population.Population;
import eva2.tools.EVAERROR;
import eva2.tools.math.Mathematics;
import java.io.Serializable;
import java.util.Arrays;

class CMAParamSet
implements InterfacePopulationChangedEventListener,
Serializable {
    private static final long serialVersionUID = -1940875082544233819L;
    protected double firstSigma = -1.0;
    protected double sigma;
    protected double d_sig;
    protected double c_sig;
    protected double[] meanX;
    protected double[] pathC;
    protected double[] pathS;
    protected double[] eigenvalues;
    protected double[] weights = null;
    protected double[][] range = null;
    protected Matrix mC;
    protected Matrix mB;
    protected boolean firstAdaptionDone = false;

    public CMAParamSet(CMAParamSet o) {
        this.firstSigma = o.firstSigma;
        this.sigma = o.sigma;
        this.d_sig = o.d_sig;
        this.c_sig = o.c_sig;
        this.meanX = (double[])o.meanX.clone();
        this.pathC = (double[])o.pathC.clone();
        this.pathS = (double[])o.pathS.clone();
        this.eigenvalues = (double[])o.eigenvalues.clone();
        this.weights = (double[])o.weights.clone();
        this.range = o.range;
        this.mC = o.mC;
        this.mB = o.mB;
        this.firstAdaptionDone = o.firstAdaptionDone;
    }

    public CMAParamSet() {
    }

    public Object clone() {
        return new CMAParamSet(this);
    }

    public String toString() {
        return "d_sig " + this.d_sig + ", c_sig " + this.c_sig + ", sigma " + this.sigma + ", firstSigma " + this.firstSigma + ", firstAdaptionDone " + this.firstAdaptionDone + ",\n meanX " + Arrays.toString(this.meanX) + ", pathC " + Arrays.toString(this.pathC) + ", pathS " + Arrays.toString(this.pathS) + ", eigenvalues " + Arrays.toString(this.eigenvalues) + ", weights " + Arrays.toString(this.weights) + ",\n mC " + this.mC.toString() + ",\n mB " + this.mB.toString();
    }

    public static CMAParamSet initCMAParams(int mu, int lambda, Population oldGen, double initialSigma) {
        return CMAParamSet.initCMAParams(new CMAParamSet(), mu, lambda, oldGen, initialSigma);
    }

    public static CMAParamSet initCMAParams(CMAParamSet params, int mu, int lambda, Population pop, double initialSigma) {
        CMAParamSet.initCMAParams(params, mu, lambda, pop.getBestEAIndividual().getDoublePosition(), ((InterfaceDataTypeDouble)((Object)pop.getEAIndividual(0))).getDoubleRange(), initialSigma);
        pop.addPopulationChangedEventListener(params);
        return params;
    }

    public static CMAParamSet initCMAParams(CMAParamSet params, int mu, int lambda, double[] center, double[][] range, double initialSigma) {
        params.firstAdaptionDone = false;
        params.range = range;
        int dim = params.range.length;
        params.eigenvalues = new double[dim];
        Arrays.fill(params.eigenvalues, 1.0);
        params.meanX = new double[dim];
        params.pathC = new double[dim];
        params.pathS = new double[dim];
        params.mC = Matrix.identity((int)dim, (int)dim);
        params.mB = Matrix.identity((int)dim, (int)dim);
        params.weights = CMAParamSet.initWeights(mu, lambda);
        double muEff = CMAParamSet.getMuEff(params.weights, mu);
        params.c_sig = (muEff + 2.0) / (muEff + (double)dim + 3.0);
        params.d_sig = params.c_sig + 1.0 + 2.0 * Math.max(0.0, Math.sqrt((muEff - 1.0) / (double)(dim + 1)) - 1.0);
        if (initialSigma < 0.0) {
            if (initialSigma != -0.25 && initialSigma != -0.5) {
                EVAERROR.errorMsgOnce("Warning, unexpected initial sigma in CMAParamSet!");
            }
            initialSigma = -initialSigma * Mathematics.getAvgRange(params.range);
        }
        if (initialSigma <= 0.0) {
            EVAERROR.errorMsgOnce("warning: initial sigma <= zero! Working with converged population?");
            initialSigma = 1.0E-9;
        }
        params.firstSigma = params.sigma = initialSigma;
        params.meanX = center;
        return params;
    }

    public static double[] initWeights(int mu, int lambda) {
        int i;
        if (lambda == 1) {
            System.err.println("Invalid lambda value in CMAParamSet.initWeights!");
            ++lambda;
        }
        double[] theWeights = new double[mu];
        double sum = 0.0;
        boolean type = false;
        for (i = 0; i < mu; ++i) {
            theWeights[i] = !type ? Math.log((double)(lambda + 1) / 2.0) - Math.log(i + 1) : 1.0;
            sum += theWeights[i];
        }
        i = 0;
        while (i < mu) {
            int n = i++;
            theWeights[n] = theWeights[n] / sum;
        }
        return theWeights;
    }

    public static double getMuEff(double[] weights, int mu) {
        double res = 0.0;
        for (int i = 0; i < mu; ++i) {
            double u = weights[i];
            res += u * u;
        }
        return 1.0 / res;
    }

    public static double getMuCov(double[] weights, int mu) {
        return CMAParamSet.getMuEff(weights, mu);
    }

    @Override
    public void registerPopulationStateChanged(Object source, String name) {
        if (name.equals("PopulationReinitOccured")) {
            int mu;
            Population pop = (Population)source;
            CMAParamSet params = (CMAParamSet)pop.getData("RankMuCMAParameters");
            if (pop.hasData("EvolutionStrategyMuParameter")) {
                mu = (Integer)pop.getData("EvolutionStrategyMuParameter");
            } else {
                System.err.println("Unknown mu in reinit! using lambda/2...");
                mu = pop.size() / 2;
            }
            pop.putData("RankMuCMAParameters", CMAParamSet.initCMAParams(params, mu, pop.size(), pop, params.firstSigma));
        }
    }
}

