/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateGINominal;
import eva2.optimization.operator.mutation.MutateGIOrdinal;
import eva2.optimization.operator.mutation.PropertyMutationMixer;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="This meta-mutation operator allows you to combine multiple alternative mutation operators.")
public class MutateEAMixer
implements InterfaceMutation,
Serializable {
    private PropertyMutationMixer mutationMixer;
    private boolean useSelfAdaption = false;
    protected double tau1 = 0.15;
    protected double lowerLimitChance = 0.05;

    public MutateEAMixer() {
        ArrayList<String> mutators = GenericObjectEditor.getClassesFromProperties(InterfaceMutation.class.getCanonicalName(), null);
        InterfaceMutation[] tmpList = new InterfaceMutation[mutators.size()];
        for (int i = 0; i < mutators.size(); ++i) {
            if (mutators.get(i).equals(this.getClass().getName())) continue;
            try {
                tmpList[i] = (InterfaceMutation)Class.forName(mutators.get(i)).newInstance();
                continue;
            }
            catch (ClassNotFoundException e) {
                System.out.println("Could not find class for " + mutators.get(i));
                continue;
            }
            catch (InstantiationException k) {
                System.out.println("Instantiation exception for " + mutators.get(i));
                continue;
            }
            catch (IllegalAccessException a) {
                System.out.println("Illegal access exception for " + mutators.get(i));
            }
        }
        this.mutationMixer = new PropertyMutationMixer(tmpList, false);
        tmpList = new InterfaceMutation[]{new MutateGINominal(), new MutateGIOrdinal()};
        this.mutationMixer.setSelectedMutators(tmpList);
        this.mutationMixer.normalizeWeights();
        this.mutationMixer.setDescriptiveString("Combining alternative mutation operators, please norm the weights!");
        this.mutationMixer.setWeightsLabel("Weigths");
    }

    public MutateEAMixer(InterfaceMutation ... mutators) {
        this.mutationMixer = new PropertyMutationMixer(mutators, true);
    }

    public MutateEAMixer(InterfaceMutation m1, InterfaceMutation m2) {
        this(new InterfaceMutation[]{m1, m2});
    }

    public MutateEAMixer(InterfaceMutation m1, InterfaceMutation m2, InterfaceMutation m3) {
        this(new InterfaceMutation[]{m1, m2, m3});
    }

    public MutateEAMixer(MutateEAMixer mutator) {
        this.mutationMixer = (PropertyMutationMixer)mutator.mutationMixer.clone();
        this.useSelfAdaption = mutator.useSelfAdaption;
        this.tau1 = mutator.tau1;
        this.lowerLimitChance = mutator.lowerLimitChance;
    }

    @Override
    public Object clone() {
        return new MutateEAMixer(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateEAMixer) {
            MutateEAMixer mut = (MutateEAMixer)mutator;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        InterfaceMutation[] mutators = this.mutationMixer.getSelectedMutators();
        for (int i = 0; i < mutators.length; ++i) {
            mutators[i].initialize(individual, opt);
        }
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        this.mutationMixer.normalizeWeights();
        double[] probs = this.mutationMixer.getWeights();
        if (this.useSelfAdaption) {
            for (int i = 0; i < probs.length; ++i) {
                int n = i;
                probs[n] = probs[n] * Math.exp(this.tau1 * RNG.gaussianDouble(1.0));
                if (probs[i] <= this.lowerLimitChance) {
                    probs[i] = this.lowerLimitChance;
                }
                if (!(probs[i] >= 1.0)) continue;
                probs[i] = 1.0;
            }
            this.mutationMixer.normalizeWeights();
        }
        InterfaceMutation[] mutators = this.mutationMixer.getSelectedMutators();
        double pointer = RNG.randomFloat(0.0f, 1.0f);
        int index = 0;
        for (double dum = probs[0]; pointer > dum && index < probs.length - 1; dum += probs[++index]) {
        }
        if (index == probs.length) {
            index = RNG.randomInt(0, probs.length - 1);
        }
        mutators[index].mutate(individual);
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
        for (int i = 0; i < this.mutationMixer.getSelectedMutators().length; ++i) {
            this.mutationMixer.getSelectedMutators()[i].crossoverOnStrategyParameters(indy1, partners);
        }
    }

    @Override
    public String getStringRepresentation() {
        return "EA mutation mixer";
    }

    public String getName() {
        return "EA mutation mixer";
    }

    public void setMutators(PropertyMutationMixer d) {
        this.mutationMixer = d;
    }

    public PropertyMutationMixer getMutators() {
        return this.mutationMixer;
    }

    public String mutatorsTipText() {
        return "Choose the set of mutators.";
    }

    public void setUseSelfAdaption(boolean d) {
        this.useSelfAdaption = d;
    }

    public boolean getUseSelfAdaption() {
        return this.useSelfAdaption;
    }

    public String useSelfAdaptionTipText() {
        return "Use my implementation of self-adaption for the mutation mixer.";
    }

    public void setLowerLimitChance(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.lowerLimitChance = d;
    }

    public double getLowerLimitChance() {
        return this.lowerLimitChance;
    }

    public String lowerLimitChanceTipText() {
        return "Set the lower limit for the mutation chance.";
    }

    public void setTau1(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau1 = d;
    }

    public double getTau1() {
        return this.tau1;
    }

    public String tau1TipText() {
        return "Set the value for tau1.";
    }
}

