/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="The correlated vector mutation stores a specific mutation vector per individual.")
public class MutateESCorrVector
implements InterfaceMutation,
Serializable {
    protected double scalingDev = 0.05;
    protected double initialVelocity = 0.02;
    protected double lowerLimitStepSize = 1.0E-7;
    protected double upperLimitStepSize = 0.5;
    protected double rotationDev = 15.0;
    protected boolean checkConstraints = true;
    public static final String vectorKey = "MutateESCorrVectorVector";

    public MutateESCorrVector() {
    }

    public MutateESCorrVector(double scalingDev) {
        this.setScalingDev(scalingDev);
    }

    public MutateESCorrVector(double scalingDev, double initialVelocity) {
        this.setScalingDev(scalingDev);
        this.setInitialVelocity(initialVelocity);
    }

    public MutateESCorrVector(double scalingDev, double initialVelocity, double rotDev) {
        this.setScalingDev(scalingDev);
        this.setInitialVelocity(initialVelocity);
        this.setRotationDev(rotDev);
    }

    public MutateESCorrVector(MutateESCorrVector mutator) {
        this.scalingDev = mutator.scalingDev;
        this.initialVelocity = mutator.initialVelocity;
        this.lowerLimitStepSize = mutator.lowerLimitStepSize;
        this.rotationDev = mutator.rotationDev;
    }

    @Override
    public Object clone() {
        return new MutateESCorrVector(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateESCorrVector) {
            MutateESCorrVector mut = (MutateESCorrVector)mutator;
            if (this.scalingDev != mut.scalingDev) {
                return false;
            }
            if (this.initialVelocity != this.initialVelocity) {
                return false;
            }
            return this.lowerLimitStepSize == mut.lowerLimitStepSize;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        double[] initVelocity = this.calcInitialVel(this.initialVelocity, ((InterfaceESIndividual)((Object)individual)).getDoubleRange());
        individual.putData(vectorKey, initVelocity);
    }

    private double[] calcInitialVel(double velocity, double[][] doubleRange) {
        double[] initVelocity = Mathematics.randomVector(doubleRange.length, 1.0);
        double nrm = Mathematics.norm(initVelocity);
        double[] shiftedRange = Mathematics.getAbsRange(doubleRange);
        Mathematics.svMult(velocity / nrm, initVelocity, initVelocity);
        Mathematics.vvMultCw(shiftedRange, initVelocity, initVelocity);
        return initVelocity;
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] genes = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] range = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            double[] vel = (double[])individual.getData(vectorKey);
            if (this.scalingDev > 0.0 || this.rotationDev > 0.0) {
                double rotateRad = this.rotationDev * (Math.PI / 360) * RNG.gaussianDouble(1.0);
                Mathematics.rotateAllAxes(vel, rotateRad, false);
                double rScale = Math.exp(RNG.gaussianDouble(this.scalingDev));
                if (this.lowerLimitStepSize > 0.0 || this.upperLimitStepSize > 0.0) {
                    double stepLen = Mathematics.norm(vel);
                    if (this.lowerLimitStepSize > 0.0) {
                        rScale = Math.max(rScale, this.lowerLimitStepSize / stepLen);
                    }
                    if (this.upperLimitStepSize > 0.0) {
                        rScale = Math.min(rScale, this.upperLimitStepSize / stepLen);
                    }
                }
                Mathematics.svMult(rScale, vel, vel);
                individual.putData(vectorKey, vel);
            }
            Mathematics.vvAdd(genes, vel, genes);
            if (this.checkConstraints) {
                Mathematics.projectToRange(genes, range);
            }
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(genes);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
        ArrayList<Double> tmpList = new ArrayList<Double>();
        if (indy1.getMutationOperator() instanceof MutateESCorrVector) {
            tmpList.add(((MutateESCorrVector)indy1.getMutationOperator()).scalingDev);
        }
        for (Object partner : partners) {
            if (!(((AbstractEAIndividual)partner).getMutationOperator() instanceof MutateESCorrVector)) continue;
            tmpList.add(((MutateESCorrVector)((AbstractEAIndividual)partner).getMutationOperator()).scalingDev);
        }
        double[] list = new double[tmpList.size()];
        for (int i = 0; i < tmpList.size(); ++i) {
            list[i] = (Double)tmpList.get(i);
        }
        if (list.length <= 1) {
            return;
        }
        this.scalingDev = list[RNG.randomInt(0, list.length - 1)];
    }

    @Override
    public String getStringRepresentation() {
        return "ES global mutation";
    }

    public String getName() {
        return "ES correlated vector mutation";
    }

    public void setScalingDev(double d) {
        this.scalingDev = d;
    }

    public double getScalingDev() {
        return this.scalingDev;
    }

    public String scalingDevTipText() {
        return "Choose the devation of lognormal vector scaling.";
    }

    public void setLowerLimitStepSize(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.lowerLimitStepSize = d;
    }

    public double getLowerLimitStepSize() {
        return this.lowerLimitStepSize;
    }

    public String lowerLimitStepSizeTipText() {
        return "Set the lower limit for the mutation step.";
    }

    public double getRotationDev() {
        return this.rotationDev;
    }

    public void setRotationDev(double rotationDeg) {
        this.rotationDev = rotationDeg;
    }

    public String rotationDevTipText() {
        return "Std deviation of the rotation angle distribution";
    }

    public double getInitialVelocity() {
        return this.initialVelocity;
    }

    public void setInitialVelocity(double velocity) {
        this.initialVelocity = velocity;
    }

    public double getUpperLimitStepSize() {
        return this.upperLimitStepSize;
    }

    public void setUpperLimitStepSize(double upperLimitStepSize) {
        this.upperLimitStepSize = upperLimitStepSize;
    }

    public String upperLimitStepSizeTipText() {
        return "Set the upper limit for the mutation step.";
    }
}

