/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The local correlated mutation stores n sigmas for each double attribute and n(n-1) alphas.")
public class MutateESCorrelated
implements InterfaceMutation,
Serializable {
    protected double mutationStepSize = 0.2;
    protected double tau1 = 0.15;
    protected double lowerLimitStepSize = 5.0E-7;
    private static final long serialVersionUID = 1L;
    private double[] sigmas = null;
    private double[] alphas = null;
    protected double tau2 = 0.15;

    public MutateESCorrelated() {
        this.sigmas = null;
        this.alphas = null;
    }

    public MutateESCorrelated(MutateESCorrelated mutator) {
        if (mutator.sigmas != null) {
            this.sigmas = new double[mutator.sigmas.length];
            System.arraycopy(mutator.sigmas, 0, this.sigmas, 0, this.sigmas.length);
        }
        if (mutator.alphas != null) {
            this.alphas = new double[mutator.alphas.length];
            System.arraycopy(mutator.alphas, 0, this.alphas, 0, this.alphas.length);
        }
        this.mutationStepSize = mutator.mutationStepSize;
        this.tau1 = mutator.tau1;
        this.tau2 = mutator.tau2;
        this.lowerLimitStepSize = mutator.lowerLimitStepSize;
    }

    @Override
    public Object clone() {
        return new MutateESCorrelated(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator == this) {
            return true;
        }
        if (mutator instanceof MutateESCorrelated) {
            int i;
            MutateESCorrelated mut = (MutateESCorrelated)mutator;
            if (this.tau1 != mut.tau1) {
                return false;
            }
            if (this.tau2 != mut.tau2) {
                return false;
            }
            if (this.lowerLimitStepSize != mut.lowerLimitStepSize) {
                return false;
            }
            if (this.sigmas != null) {
                for (i = 0; i < this.sigmas.length; ++i) {
                    if (this.sigmas[i] == mut.sigmas[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
            if (this.alphas != null) {
                for (i = 0; i < this.alphas.length; ++i) {
                    if (this.alphas[i] == mut.alphas[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        if (individual instanceof InterfaceESIndividual) {
            int i;
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            if (this.sigmas == null) {
                this.sigmas = new double[x.length];
                for (i = 0; i < this.sigmas.length; ++i) {
                    this.sigmas[i] = this.mutationStepSize;
                }
            }
            if (this.alphas == null) {
                this.alphas = new double[x.length * (x.length - 1) / 2];
                for (i = 0; i < this.alphas.length; ++i) {
                    this.alphas[i] = 0.0;
                }
            }
        }
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            int i;
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[] xCopy = new double[x.length];
            double[][] range = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            double tmpR = RNG.gaussianDouble(1.0);
            for (i = 0; i < x.length; ++i) {
                int n = i;
                this.sigmas[n] = this.sigmas[n] * Math.exp(this.tau1 * tmpR + this.tau2 * RNG.gaussianDouble(1.0));
                if (!(this.sigmas[i] < this.lowerLimitStepSize)) continue;
                this.sigmas[i] = this.lowerLimitStepSize;
            }
            for (i = 0; i < this.alphas.length; ++i) {
                int n = i;
                this.alphas[n] = this.alphas[n] + RNG.gaussianDouble(0.2);
                if (this.alphas[i] < -1.5707963267948966) {
                    this.alphas[i] = -1.5707963267948966;
                }
                if (!(this.alphas[i] > 1.5707963267948966)) continue;
                this.alphas[i] = 1.5707963267948966;
            }
            for (i = 0; i < x.length; ++i) {
                xCopy[i] = RNG.gaussianDouble(this.sigmas[i]);
            }
            for (i = 0; i < x.length - 1; ++i) {
                for (int j = i + 1; j < x.length; ++j) {
                    double alpha = this.getAlpha(i, j, x.length);
                    double xX = Math.cos(alpha) * xCopy[i] - Math.sin(alpha) * xCopy[j];
                    double xY = Math.sin(alpha) * xCopy[i] + Math.cos(alpha) * xCopy[j];
                    xCopy[i] = xX;
                    xCopy[j] = xY;
                }
            }
            for (i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] + (range[i][1] - range[i][0]) / 2.0 * xCopy[i];
                if (range[i][0] > x[i]) {
                    x[i] = range[i][0];
                }
                if (!(range[i][1] < x[i])) continue;
                x[i] = range[i][1];
            }
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    private double getAlpha(int i, int j, int n) {
        int sum = 0;
        if (i < j) {
            for (int count = 0; count < i; ++count) {
                sum += n - count - 1;
            }
            sum += j - i;
            return this.alphas[--sum];
        }
        System.err.println("Falscher Zugriff auf Alphaliste!");
        return 0.0;
    }

    @Override
    public String getStringRepresentation() {
        return "ES local correlated mutation";
    }

    public String getName() {
        return "ES local correlated mutation";
    }

    public void setTau2(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau2 = d;
    }

    public double getTau2() {
        return this.tau2;
    }

    public String tau2TipText() {
        return "Set the value for tau2.";
    }

    public void setMutationStepSize(double d) {
        if (d < 0.0) {
            d = this.lowerLimitStepSize;
        }
        this.mutationStepSize = d;
    }

    public double getMutationStepSize() {
        return this.mutationStepSize;
    }

    public String mutationStepSizeTipText() {
        return "Choose the initial mutation step size.";
    }

    public void setLowerLimitStepSize(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.lowerLimitStepSize = d;
    }

    public double getLowerLimitStepSize() {
        return this.lowerLimitStepSize;
    }

    public String lowerLimitStepSizeTipText() {
        return "Set the lower limit for the mutation step size.";
    }

    public void setTau1(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau1 = d;
    }

    public double getTau1() {
        return this.tau1;
    }

    public String tau1TipText() {
        return "Set the value for tau1.";
    }
}

