/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is the most sophisticated CMA mutation.")
public class MutateESCovarianceMatrixAdaption
implements InterfaceMutation,
Serializable {
    protected int D;
    protected double[] Z;
    protected double sigmaGlobal = 1.0;
    protected double initSigmaScalar = -1.0;
    protected double c;
    protected double cu;
    protected double cov;
    protected double Beta;
    protected double[] s_N;
    protected double[] pathS;
    protected double[] Bz;
    protected double xi_dach;
    protected Matrix C;
    protected Matrix B;
    protected boolean checkConstraints = false;
    protected int constraintMaxTries = 50;
    protected int counter;
    protected int frequency = 1;
    protected double[] eigenValues;

    public MutateESCovarianceMatrixAdaption() {
    }

    public MutateESCovarianceMatrixAdaption(MutateESCovarianceMatrixAdaption mutator) {
        this.counter = mutator.counter;
        this.frequency = mutator.frequency;
        this.initSigmaScalar = mutator.initSigmaScalar;
        this.constraintMaxTries = mutator.constraintMaxTries;
        this.checkConstraints = mutator.checkConstraints;
        this.D = mutator.D;
        this.sigmaGlobal = mutator.sigmaGlobal;
        this.c = mutator.c;
        this.cu = mutator.cu;
        this.cov = mutator.cov;
        this.Beta = mutator.Beta;
        this.xi_dach = mutator.xi_dach;
        if (mutator.s_N != null) {
            this.s_N = (double[])mutator.s_N.clone();
        }
        if (mutator.pathS != null) {
            this.pathS = (double[])mutator.pathS.clone();
        }
        if (mutator.Bz != null) {
            this.Bz = (double[])mutator.Bz.clone();
        }
        if (mutator.C != null) {
            this.C = (Matrix)mutator.C.clone();
        }
        if (mutator.B != null) {
            this.B = (Matrix)mutator.B.clone();
        }
        if (mutator.Z != null) {
            this.Z = (double[])mutator.Z.clone();
        }
        if (mutator.eigenValues != null) {
            this.eigenValues = (double[])mutator.eigenValues.clone();
        }
    }

    public MutateESCovarianceMatrixAdaption(boolean doCheckConstraints) {
        this.setCheckConstraints(doCheckConstraints);
    }

    @Override
    public Object clone() {
        return new MutateESCovarianceMatrixAdaption(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator == this) {
            return true;
        }
        if (mutator instanceof MutateESCovarianceMatrixAdaption) {
            MutateESCovarianceMatrixAdaption mut = (MutateESCovarianceMatrixAdaption)mutator;
            try {
                double[][] c2;
                if (this.C == mut.C) {
                    return true;
                }
                double[][] c1 = this.C.getArray();
                if (c1 == (c2 = mut.C.getArray())) {
                    return true;
                }
                for (int i = 0; i < c1.length; ++i) {
                    for (int j = 0; j < c1[i].length; ++j) {
                        if (c1[i][j] == c2[i][j]) continue;
                        return false;
                    }
                }
            }
            catch (NullPointerException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        if (!(individual instanceof InterfaceESIndividual)) {
            return;
        }
        double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
        double[][] ranges = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
        this.counter = this.frequency;
        if (this.initSigmaScalar > 0.0) {
            this.sigmaGlobal = this.initSigmaScalar;
        } else {
            double avgRange = Mathematics.getAvgRange(ranges);
            this.sigmaGlobal = 0.25 * avgRange;
        }
        System.out.println("Init sigma: " + this.sigmaGlobal);
        this.D = x.length;
        this.C = Matrix.identity((int)this.D, (int)this.D);
        EigenvalueDecomposition helper = new EigenvalueDecomposition(this.C);
        this.B = helper.getV();
        this.c = Math.sqrt(1.0 / (double)this.D);
        this.cu = Math.sqrt((2.0 - this.c) / this.c);
        this.Beta = this.c;
        this.cov = 2.0 / ((double)this.D * (double)this.D);
        this.Z = new double[this.D];
        this.s_N = new double[this.D];
        this.Bz = new double[this.D];
        this.pathS = new double[this.D];
        for (int i = 0; i < this.D; ++i) {
            this.s_N[i] = 0.0;
            this.Bz[i] = 0.0;
            this.pathS[i] = 0.0;
        }
        this.xi_dach = Math.sqrt((double)this.D - 0.5);
        this.evaluateNewObjectX(x, ranges);
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] ranges = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            this.adaptStrategy();
            this.evaluateNewObjectX(x, ranges);
            for (int i = 0; i < x.length; ++i) {
                if (x[i] < ranges[i][0]) {
                    x[i] = ranges[i][0];
                }
                if (!(x[i] > ranges[i][1])) continue;
                x[i] = ranges[i][1];
            }
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    protected void adaptStrategy() {
        int j;
        int i;
        double pathLen = 0.0;
        for (i = 0; i < this.D; ++i) {
            this.s_N[i] = (1.0 - this.c) * this.s_N[i] + this.c * this.cu * this.Bz[i];
        }
        for (i = 0; i < this.D; ++i) {
            for (j = i; j < this.D; ++j) {
                double Cij = (1.0 - this.cov) * this.C.get(i, j) + this.cov * this.s_N[i] * this.s_N[j];
                this.C.set(i, j, Cij);
                this.C.set(j, i, Cij);
            }
        }
        for (i = 0; i < this.D; ++i) {
            double Bz_d = 0.0;
            for (j = 0; j < this.D; ++j) {
                Bz_d += this.B.get(i, j) * this.Z[j];
            }
            this.pathS[i] = (1.0 - this.c) * this.pathS[i] + this.c * this.cu * Bz_d;
            pathLen += this.pathS[i] * this.pathS[i];
        }
        this.sigmaGlobal *= Math.exp(this.Beta * this.c * (Math.sqrt(pathLen) - this.xi_dach));
    }

    protected void evaluateNewObjectX(double[] x, double[][] range) {
        double[] oldX = (double[])x.clone();
        for (int i = 0; i < this.D; ++i) {
            this.Z[i] = RNG.gaussianDouble(1.0);
        }
        this.C = this.C.plus(this.C.transpose()).times(0.5);
        ++this.counter;
        if (this.counter >= this.frequency) {
            this.counter = 0;
            EigenvalueDecomposition helper = new EigenvalueDecomposition(this.C);
            this.B = helper.getV();
            this.eigenValues = helper.getRealEigenvalues();
        }
        boolean isNewPosFeasible = false;
        int counter = 0;
        block1: while (!isNewPosFeasible && counter < this.constraintMaxTries) {
            int j;
            int i;
            for (i = 0; i < this.D; ++i) {
                this.Bz[i] = 0.0;
                for (j = 0; j < this.D; ++j) {
                    int n = i;
                    this.Bz[n] = this.Bz[n] + Math.sqrt(Math.abs(this.eigenValues[j])) * this.B.get(i, j) * this.Z[j];
                }
                int n = i;
                x[n] = x[n] + this.sigmaGlobal * this.Bz[i];
            }
            isNewPosFeasible = true;
            if (!this.checkConstraints) continue;
            for (i = 0; i < this.D; ++i) {
                if (!(x[i] < range[i][0]) && !(x[i] > range[i][1])) continue;
                for (j = 0; j < this.D; ++j) {
                    x[j] = oldX[j] - this.sigmaGlobal * this.Bz[j];
                }
                this.sigmaGlobal *= 0.5;
                isNewPosFeasible = false;
                ++counter;
                continue block1;
            }
        }
        if (counter > 0) {
            // empty if block
        }
        if (this.checkConstraints && !isNewPosFeasible) {
            Mathematics.projectToRange(x, range);
        }
    }

    @Override
    public String getStringRepresentation() {
        return "CMA mutation";
    }

    public String getName() {
        return "CMA mutation";
    }

    public void setCheckConstraints(boolean bit) {
        this.checkConstraints = bit;
    }

    public boolean getCheckConstraints() {
        return this.checkConstraints;
    }

    public String checkConstraintsTipText() {
        return "Toggle check constraints.";
    }

    public void setInitSigmaScalar(double d) {
        this.initSigmaScalar = d;
    }

    public double getInitSigmaScalar() {
        return this.initSigmaScalar;
    }

    public String initSigmaScalarTipText() {
        return "Set the initial sigma value, or -1 to use quarter average range of the problem.";
    }
}

