/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceAdaptOperatorGenerational;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateESCovarianceMatrixAdaption;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.util.annotation.Description;

@Description(value="This is the CMA mutation according to Igel,Hansen,Roth 2007")
public class MutateESCovarianceMatrixAdaptionPlus
extends MutateESCovarianceMatrixAdaption
implements InterfaceMutation,
InterfaceAdaptOperatorGenerational {
    protected double psuccess;
    protected double cp;
    protected double psuccesstarget = 0.44;
    protected double stepd;
    protected double pthresh;
    protected int lambda = 1;

    public MutateESCovarianceMatrixAdaptionPlus() {
    }

    public MutateESCovarianceMatrixAdaptionPlus(MutateESCovarianceMatrixAdaptionPlus mutator) {
        super(mutator);
        this.psuccess = mutator.psuccess;
        this.cp = mutator.cp;
        this.psuccesstarget = mutator.psuccesstarget;
        this.lambda = mutator.lambda;
        this.pthresh = mutator.pthresh;
        this.stepd = mutator.stepd;
    }

    @Override
    public Object clone() {
        return new MutateESCovarianceMatrixAdaptionPlus(this);
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        if (!(individual instanceof InterfaceESIndividual)) {
            return;
        }
        super.initialize(individual, opt);
        this.psuccess = this.psuccesstarget = 1.0 / (5.0 + Math.sqrt(this.lambda) / 2.0);
        this.stepd = 1.0 + (double)this.D / (2.0 * (double)this.lambda);
        this.cp = this.psuccesstarget * (double)this.lambda / (2.0 + this.psuccesstarget * (double)this.lambda);
        this.c = 2.0 / (2.0 + (double)this.D);
        this.cov = 2.0 / (6.0 + Math.pow(this.D, 2.0));
        this.pthresh = 0.44;
    }

    protected void adaptStrategyGen(AbstractEAIndividual child, AbstractEAIndividual parent) {
        if (child.getFitness(0) <= parent.getFitness(0)) {
            this.updateCovariance(child, parent);
        }
    }

    public void updateCovariance(AbstractEAIndividual child, AbstractEAIndividual parent) {
        double[] step = new double[this.D];
        for (int i = 0; i < this.D; ++i) {
            step[i] = ((InterfaceESIndividual)((Object)parent)).getDGenotype()[i] - ((InterfaceESIndividual)((Object)child)).getDGenotype()[i];
        }
        this.updateCovariance(step);
    }

    public void updateCovariance() {
        double[] step = new double[this.D];
        System.arraycopy(this.Bz, 0, step, 0, this.D);
        this.updateCovariance(step);
    }

    public void updateCovariance(double[] step) {
        for (int i = 0; i < this.D; ++i) {
            this.pathS[i] = this.psuccess < this.pthresh ? (1.0 - this.c) * this.pathS[i] + Math.sqrt(this.c * (2.0 - this.c)) * step[i] / this.sigmaGlobal : (1.0 - this.c) * this.pathS[i];
        }
        if (this.psuccess < this.pthresh) {
            this.C = this.C.times(1.0 - this.cov);
            this.C.plusEquals(Mathematics.outer(this.pathS, this.pathS).times(this.cov));
        } else {
            this.C = this.C.times(1.0 - this.cov).plus(Mathematics.outer(this.pathS, this.pathS).plus(this.C.times(this.c * (2.0 - this.c))).times(this.cov));
        }
    }

    @Override
    protected void adaptStrategy() {
    }

    public int getLambda() {
        return this.lambda;
    }

    public void setLambda(int mLambda) {
        this.lambda = mLambda;
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public void adaptAfterSelection(Population oldPop, Population selectedPop) {
    }

    @Override
    public void adaptGenerational(Population selectedPop, Population parentPop, Population newPop, boolean updateSelected) {
        MutateESCovarianceMatrixAdaptionPlus mutator;
        int i;
        double rate = 0.0;
        for (i = 0; i < parentPop.size(); ++i) {
            if (!(newPop.getEAIndividual(i).getFitness(0) < parentPop.getEAIndividual(i).getFitness(0))) continue;
            rate += 1.0;
        }
        rate /= (double)parentPop.size();
        if (updateSelected) {
            for (i = 0; i < selectedPop.size(); ++i) {
                mutator = (MutateESCovarianceMatrixAdaptionPlus)((AbstractEAIndividual)selectedPop.get(i)).getMutationOperator();
                this.updateMutator(rate, mutator);
                if (!(selectedPop.getEAIndividual(i).getFitness(0) <= parentPop.getEAIndividual(0).getFitness(0))) continue;
                mutator.adaptStrategyGen(selectedPop.getEAIndividual(i), parentPop.getEAIndividual(0));
            }
        }
        for (i = 0; i < newPop.size(); ++i) {
            mutator = (MutateESCovarianceMatrixAdaptionPlus)((AbstractEAIndividual)newPop.get(i)).getMutationOperator();
            this.updateMutator(rate, mutator);
            if (!(newPop.getEAIndividual(i).getFitness(0) <= parentPop.getEAIndividual(0).getFitness(0))) continue;
            mutator.adaptStrategyGen(newPop.getEAIndividual(i), parentPop.getEAIndividual(0));
        }
    }

    private void updateMutator(double rate, MutateESCovarianceMatrixAdaptionPlus mutator) {
        mutator.updateStepSize(rate);
    }

    public double getPSuccess() {
        return this.psuccess;
    }

    public void updateStepSize(double psuccess) {
        this.psuccess = (1.0 - this.cp) * this.psuccess + this.cp * psuccess;
        this.sigmaGlobal *= Math.exp(1.0 / this.stepd * (this.psuccess - this.psuccesstarget) / (1.0 - this.psuccesstarget));
    }

    @Override
    public String getName() {
        return "CMA mutation for plus Strategies";
    }

    @Override
    public String getStringRepresentation() {
        return "CMA-plus mutation";
    }
}

