/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The fixed step size mutation alters all elements with a fixed mutation step size.")
public class MutateESFixedStepSize
implements InterfaceMutation,
Serializable {
    protected double sigma = 0.005;

    public MutateESFixedStepSize() {
    }

    public MutateESFixedStepSize(MutateESFixedStepSize mutator) {
        this.sigma = mutator.sigma;
    }

    public MutateESFixedStepSize(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public Object clone() {
        return new MutateESFixedStepSize(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateESFixedStepSize) {
            MutateESFixedStepSize mut = (MutateESFixedStepSize)mutator;
            return this.sigma == mut.sigma;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] range = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] + (range[i][1] - range[i][0]) / 2.0 * RNG.gaussianDouble(this.sigma);
                if (range[i][0] > x[i]) {
                    x[i] = range[i][0];
                }
                if (!(range[i][1] < x[i])) continue;
                x[i] = range[i][1];
            }
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "ES fixed step size mutation " + this.getSigma();
    }

    public String getName() {
        return "ES fixed step size mutation";
    }

    public void setSigma(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.sigma = d;
    }

    public double getSigma() {
        return this.sigma;
    }

    public String sigmaTipText() {
        return "Set the value for the fixed sigma.";
    }
}

