/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.enums.MutateESCrossoverType;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="The global mutation stores only one sigma for all double attributes.")
public class MutateESGlobal
implements InterfaceMutation,
Serializable,
InterfaceAdditionalPopulationInformer {
    protected double mutationStepSize = 0.2;
    protected double tau1 = 0.15;
    protected double lowerLimitStepSize = 5.0E-7;
    protected MutateESCrossoverType crossoverType = MutateESCrossoverType.none;

    public MutateESGlobal() {
    }

    public MutateESGlobal(double mutationStepSize) {
        this(mutationStepSize, MutateESCrossoverType.none);
    }

    public MutateESGlobal(double mutationStepSize, MutateESCrossoverType coType) {
        this.setMutationStepSize(mutationStepSize);
        this.setCrossoverType(coType);
    }

    public MutateESGlobal(MutateESGlobal mutator) {
        this.mutationStepSize = mutator.mutationStepSize;
        this.tau1 = mutator.tau1;
        this.lowerLimitStepSize = mutator.lowerLimitStepSize;
        this.crossoverType = mutator.crossoverType;
    }

    @Override
    public Object clone() {
        return new MutateESGlobal(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateESGlobal) {
            MutateESGlobal mut = (MutateESGlobal)mutator;
            if (this.mutationStepSize != mut.mutationStepSize) {
                return false;
            }
            if (this.tau1 != mut.tau1) {
                return false;
            }
            return this.lowerLimitStepSize == mut.lowerLimitStepSize;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] range = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            this.mutationStepSize *= Math.exp(this.tau1 * RNG.gaussianDouble(1.0));
            if (this.mutationStepSize < this.lowerLimitStepSize) {
                this.mutationStepSize = this.lowerLimitStepSize;
            }
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] + (range[i][1] - range[i][0]) / 2.0 * RNG.gaussianDouble(this.mutationStepSize);
                if (range[i][0] > x[i]) {
                    x[i] = range[i][0];
                }
                if (!(range[i][1] < x[i])) continue;
                x[i] = range[i][1];
            }
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
        if (this.crossoverType != MutateESCrossoverType.none) {
            int i;
            ArrayList<Double> tmpList = new ArrayList<Double>();
            if (indy1.getMutationOperator() instanceof MutateESGlobal) {
                tmpList.add(((MutateESGlobal)indy1.getMutationOperator()).mutationStepSize);
            }
            for (int i2 = 0; i2 < partners.size(); ++i2) {
                if (!(((AbstractEAIndividual)partners.get(i2)).getMutationOperator() instanceof MutateESGlobal)) continue;
                tmpList.add(((MutateESGlobal)((AbstractEAIndividual)partners.get((int)i2)).getMutationOperator()).mutationStepSize);
            }
            double[] list = new double[tmpList.size()];
            for (i = 0; i < tmpList.size(); ++i) {
                list[i] = (Double)tmpList.get(i);
            }
            if (list.length <= 1) {
                return;
            }
            switch (this.crossoverType) {
                case intermediate: {
                    this.mutationStepSize = 0.0;
                    for (i = 0; i < list.length; ++i) {
                        this.mutationStepSize += list[i];
                    }
                    this.mutationStepSize /= (double)list.length;
                    break;
                }
                case discrete: {
                    this.mutationStepSize = list[RNG.randomInt(0, list.length - 1)];
                    break;
                }
            }
        }
    }

    @Override
    public String getStringRepresentation() {
        return "ES global mutation";
    }

    public String getName() {
        return "ES global mutation";
    }

    public void setMutationStepSize(double d) {
        if (d < 0.0) {
            d = this.lowerLimitStepSize;
        }
        this.mutationStepSize = d;
    }

    public double getMutationStepSize() {
        return this.mutationStepSize;
    }

    public String mutationStepSizeTipText() {
        return "Choose the initial mutation step size.";
    }

    public void setLowerLimitStepSize(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.lowerLimitStepSize = d;
    }

    public double getLowerLimitStepSize() {
        return this.lowerLimitStepSize;
    }

    public String lowerLimitStepSizeTipText() {
        return "Set the lower limit for the mutation step size.";
    }

    public void setTau1(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau1 = d;
    }

    public double getTau1() {
        return this.tau1;
    }

    public String tau1TipText() {
        return "Set the value for tau1.";
    }

    public void setCrossoverType(MutateESCrossoverType d) {
        this.crossoverType = d;
    }

    public MutateESCrossoverType getCrossoverType() {
        return this.crossoverType;
    }

    public String crossoverTypeTipText() {
        return "Choose the crossover type for the strategy parameters.";
    }

    @Override
    public String[] getAdditionalDataHeader() {
        return new String[]{"sigma"};
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return new String[]{"The ES global mutation step size."};
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        return new Object[]{this.mutationStepSize};
    }
}

