/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.optimization.population.PopulationInterface;
import eva2.problems.InterfaceAdditionalPopulationInformer;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import eva2.util.annotation.Parameter;
import java.io.Serializable;
import java.util.ArrayList;

@Description(value="The local mutation stores n sigmas for each double attribute.")
public class MutateESLocal
implements InterfaceMutation,
InterfaceAdditionalPopulationInformer,
Serializable {
    protected double mutationStepSize = 0.2;
    protected double tau1 = 0.15;
    protected double lowerLimitStepSize = 5.0E-7;
    private double[] sigmas;
    protected double tau2 = 0.15;
    protected CrossoverType crossoverType;

    public MutateESLocal() {
        this.sigmas = null;
        this.crossoverType = CrossoverType.None;
    }

    public MutateESLocal(MutateESLocal mutator) {
        if (mutator.sigmas != null) {
            this.sigmas = new double[mutator.sigmas.length];
            System.arraycopy(mutator.sigmas, 0, this.sigmas, 0, this.sigmas.length);
        }
        this.mutationStepSize = mutator.mutationStepSize;
        this.tau1 = mutator.tau1;
        this.tau2 = mutator.tau2;
        this.lowerLimitStepSize = mutator.lowerLimitStepSize;
        this.crossoverType = mutator.crossoverType;
    }

    @Override
    public Object clone() {
        return new MutateESLocal(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator == this) {
            return true;
        }
        if (mutator instanceof MutateESLocal) {
            MutateESLocal mut = (MutateESLocal)mutator;
            if (this.tau1 != mut.tau1) {
                return false;
            }
            if (this.tau2 != mut.tau2) {
                return false;
            }
            if (this.lowerLimitStepSize != mut.lowerLimitStepSize) {
                return false;
            }
            if (this.sigmas != null) {
                for (int i = 0; i < this.sigmas.length; ++i) {
                    if (this.sigmas[i] == mut.sigmas[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        if (individual instanceof InterfaceESIndividual) {
            this.sigmas = new double[((InterfaceESIndividual)((Object)individual)).getDGenotype().length];
            for (int i = 0; i < this.sigmas.length; ++i) {
                this.sigmas[i] = this.mutationStepSize;
            }
        }
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] range = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            double tmpR = RNG.gaussianDouble(1.0);
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                this.sigmas[n] = this.sigmas[n] * Math.exp(this.tau1 * tmpR + this.tau2 * RNG.gaussianDouble(1.0));
                if (this.sigmas[i] < this.lowerLimitStepSize) {
                    this.sigmas[i] = this.lowerLimitStepSize;
                }
                int n2 = i;
                x[n2] = x[n2] + (range[i][1] - range[i][0]) / 2.0 * RNG.gaussianDouble(this.sigmas[i]);
                if (range[i][0] > x[i]) {
                    x[i] = range[i][0];
                }
                if (!(range[i][1] < x[i])) continue;
                x[i] = range[i][1];
            }
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
        int i;
        ArrayList<Double> tmpListA = new ArrayList<Double>();
        ArrayList<double[]> tmpListB = new ArrayList<double[]>();
        if (indy1.getMutationOperator() instanceof MutateESLocal) {
            tmpListA.add(((MutateESLocal)indy1.getMutationOperator()).mutationStepSize);
            tmpListB.add(((MutateESLocal)indy1.getMutationOperator()).sigmas);
        }
        for (int i2 = 0; i2 < partners.size(); ++i2) {
            if (!(((AbstractEAIndividual)partners.get(i2)).getMutationOperator() instanceof MutateESLocal)) continue;
            tmpListA.add(((MutateESLocal)((AbstractEAIndividual)partners.get((int)i2)).getMutationOperator()).mutationStepSize);
            tmpListB.add(((MutateESLocal)((AbstractEAIndividual)partners.get((int)i2)).getMutationOperator()).sigmas);
        }
        double[] listA = new double[tmpListA.size()];
        double[][] listB = new double[tmpListA.size()][];
        for (i = 0; i < tmpListA.size(); ++i) {
            listA[i] = (Double)tmpListA.get(i);
            listB[i] = (double[])tmpListB.get(i);
        }
        if (listA.length <= 1) {
            return;
        }
        switch (this.crossoverType) {
            case Intermediate: {
                this.mutationStepSize = 0.0;
                for (i = 0; i < this.sigmas.length; ++i) {
                    this.sigmas[i] = 0.0;
                }
                for (i = 0; i < listA.length; ++i) {
                    this.mutationStepSize += listA[i];
                    for (int j = 0; j < this.sigmas.length; ++j) {
                        int n = j;
                        this.sigmas[n] = this.sigmas[n] + listB[i][j];
                    }
                }
                this.mutationStepSize /= (double)listA.length;
                i = 0;
                while (i < this.sigmas.length) {
                    int n = i++;
                    this.sigmas[n] = this.sigmas[n] / (double)listA.length;
                }
                break;
            }
            case Discrete: {
                int rn = RNG.randomInt(0, listA.length - 1);
                this.mutationStepSize = listA[rn];
                for (int i3 = 0; i3 < this.sigmas.length; ++i3) {
                    rn = RNG.randomInt(0, listA.length - 1);
                    this.sigmas[i3] = listB[rn][i3];
                }
                break;
            }
        }
    }

    @Override
    public String getStringRepresentation() {
        return "ES local mutation";
    }

    public String getName() {
        return "ES local mutation";
    }

    @Parameter(description="Choose the initial mutation step size sigma.")
    public void setMutationStepSize(double d) {
        if (d < 0.0) {
            d = this.lowerLimitStepSize;
        }
        this.mutationStepSize = d;
    }

    public double getMutationStepSize() {
        return this.mutationStepSize;
    }

    @Parameter(description="Set the lower limit for the mutation step size.")
    public void setLowerLimitStepSize(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.lowerLimitStepSize = d;
    }

    public double getLowerLimitStepSize() {
        return this.lowerLimitStepSize;
    }

    @Parameter(description="Set the value for tau1.")
    public void setTau1(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau1 = d;
    }

    public double getTau1() {
        return this.tau1;
    }

    @Parameter(description="Set the value for tau2.")
    public void setTau2(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau2 = d;
    }

    public double getTau2() {
        return this.tau2;
    }

    @Parameter(description="Choose the crossover type for the strategy parameters.")
    public void setCrossoverType(CrossoverType d) {
        this.crossoverType = d;
    }

    public CrossoverType getCrossoverType() {
        return this.crossoverType;
    }

    @Override
    public String[] getAdditionalDataHeader() {
        return new String[]{"sigma"};
    }

    @Override
    public String[] getAdditionalDataInfo() {
        return new String[]{"The ES local mutation step sizes."};
    }

    @Override
    public Object[] getAdditionalDataValue(PopulationInterface pop) {
        return new Object[]{this.sigmas};
    }

    public static enum CrossoverType {
        None,
        Intermediate,
        Discrete;

    }
}

