/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="This is the most sophisticated MVA mutation.")
public class MutateESMainVectorAdaption
implements InterfaceMutation,
Serializable {
    private boolean checkConstraints = true;
    public static final String Name = "MVA";
    private int N;
    private double[] Z;
    private double sigmaScalar = 1.0;
    private double initSigmaScalar = 1.0;
    private double c;
    private double cov;
    private double beta;
    private double[] sN;
    private double[] dN;
    private double[] mainV;
    private double xi_dach;
    private double Z1;
    private double w_v = 3.0;

    public MutateESMainVectorAdaption() {
    }

    public MutateESMainVectorAdaption(MutateESMainVectorAdaption mutator) {
        this.N = mutator.N;
        this.sigmaScalar = mutator.sigmaScalar;
        this.initSigmaScalar = mutator.initSigmaScalar;
        this.c = mutator.c;
        this.cov = mutator.cov;
        this.beta = mutator.beta;
        this.xi_dach = mutator.xi_dach;
        this.Z1 = mutator.Z1;
        this.w_v = mutator.w_v;
        if (mutator.mainV != null) {
            this.mainV = (double[])mutator.mainV.clone();
        }
        if (mutator.Z != null) {
            this.Z = (double[])mutator.Z.clone();
        }
        if (mutator.sN != null) {
            this.sN = (double[])mutator.sN.clone();
        }
        if (mutator.dN != null) {
            this.dN = (double[])mutator.dN.clone();
        }
    }

    @Override
    public Object clone() {
        return new MutateESMainVectorAdaption(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (this == mutator) {
            return true;
        }
        if (mutator instanceof MutateESMainVectorAdaption) {
            MutateESMainVectorAdaption mut = (MutateESMainVectorAdaption)mutator;
            if (this.mainV == mut.mainV) {
                return true;
            }
            if (this.mainV != null) {
                for (int i = 0; i < this.mainV.length; ++i) {
                    if (this.mainV[i] == mut.mainV[i]) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        int i;
        if (!(individual instanceof InterfaceESIndividual)) {
            return;
        }
        double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
        double[][] ranges = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
        this.sigmaScalar = this.initSigmaScalar;
        this.N = x.length;
        this.beta = this.c = Math.sqrt(1.0 / (double)this.N);
        this.cov = 2.0 / ((double)this.N * (double)this.N);
        this.Z = new double[this.N];
        this.sN = new double[this.N];
        this.dN = new double[this.N];
        this.mainV = new double[this.N];
        for (i = 0; i < this.N; ++i) {
            this.sN[i] = 0.0;
            this.dN[i] = 0.0;
            this.mainV[i] = 0.0;
        }
        this.xi_dach = Math.sqrt((double)this.N - 0.5);
        for (i = 0; i < this.N; ++i) {
            this.Z[i] = RNG.gaussianDouble(1.0);
        }
        this.Z1 = RNG.gaussianDouble(1.0);
        this.evaluateNewObjectX(x, ranges);
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] ranges = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            this.adaptStrategy();
            for (int i = 0; i < this.N; ++i) {
                this.Z[i] = RNG.gaussianDouble(1.0);
            }
            this.Z1 = RNG.gaussianDouble(1.0);
            this.evaluateNewObjectX(x, ranges);
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    private void adaptStrategy() {
        int i;
        double length = 0.0;
        for (int i2 = 0; i2 < this.N; ++i2) {
            this.dN[i2] = (1.0 - this.c) * this.dN[i2] + Math.sqrt(this.c * (2.0 - this.c)) * this.Z[i2];
            length += this.dN[i2] * this.dN[i2];
        }
        this.sigmaScalar *= Math.exp(this.beta * this.c * (Math.sqrt(length) - this.xi_dach));
        double Product = 0.0;
        for (i = 0; i < this.N; ++i) {
            Product += this.sN[i] * this.mainV[i];
        }
        Product = Product < 0.0 ? -1.0 : 1.0;
        for (i = 0; i < this.N; ++i) {
            this.sN[i] = (1.0 - this.c) * this.sN[i] + Math.sqrt(this.c * (2.0 - this.c)) * (this.Z[i] + this.Z1 * this.w_v * this.mainV[i]);
            this.mainV[i] = (1.0 - this.cov) * Product * this.mainV[i] + this.cov * this.sN[i];
        }
    }

    private void evaluateNewObjectX(double[] x, double[][] range) {
        int i;
        if (Double.isNaN(x[0])) {
            System.err.println("treffer in mva " + x[0]);
        }
        double[] v = (double[])this.mainV.clone();
        double[] grad = new double[x.length];
        double vl = 0.0;
        double gradl = 0.0;
        for (i = 0; i < x.length; ++i) {
            grad[i] = 2.0 * x[i];
            vl += v[i] * v[i];
            gradl += grad[i] * grad[i];
        }
        vl = Math.sqrt(vl);
        gradl = Math.sqrt(gradl);
        for (i = 0; i < x.length; ++i) {
            int n = i;
            v[n] = v[n] / vl;
            int n2 = i;
            grad[n2] = grad[n2] / gradl;
            int n3 = i;
            x[n3] = x[n3] + this.sigmaScalar * (this.Z[i] + this.Z1 * this.w_v * this.mainV[i]);
        }
        if (this.getCheckConstraints()) {
            Mathematics.projectToRange(x, range);
        }
    }

    @Override
    public String getStringRepresentation() {
        return "MVA mutation";
    }

    public String getName() {
        return "MVA mutation";
    }

    public void setCheckConstraints(boolean bit) {
        this.checkConstraints = bit;
    }

    public boolean getCheckConstraints() {
        return this.checkConstraints;
    }

    public String checkConstraintsTipText() {
        return "Toggle check constraints.";
    }
}

