/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The mutative step size control mutation randomly increases/decreases the current step size.")
public class MutateESMutativeStepSizeControl
implements InterfaceMutation,
Serializable {
    protected double mutationStepSize = 0.2;
    protected double alpha = 1.2;
    protected double lowerLimitStepSize = 5.0E-7;
    protected double upperLimitStepSize = 0.4;

    public MutateESMutativeStepSizeControl() {
    }

    public MutateESMutativeStepSizeControl(double initialStepSize, double lowerLimit, double upperLimit) {
        this.mutationStepSize = initialStepSize;
        if (this.lowerLimitStepSize > this.upperLimitStepSize) {
            System.err.println("Invalid step size bounds, switching upper and lower...");
            double tmp = upperLimit;
            upperLimit = lowerLimit;
            lowerLimit = tmp;
        }
        this.lowerLimitStepSize = lowerLimit;
        this.upperLimitStepSize = upperLimit;
        if (initialStepSize < lowerLimit || initialStepSize > upperLimit) {
            this.mutationStepSize = (upperLimit + lowerLimit) / 2.0;
            System.err.println("Invalid initial stepsize, setting it to " + this.mutationStepSize);
        }
    }

    public MutateESMutativeStepSizeControl(MutateESMutativeStepSizeControl mutator) {
        this.mutationStepSize = mutator.mutationStepSize;
        this.alpha = mutator.alpha;
        this.lowerLimitStepSize = mutator.lowerLimitStepSize;
        this.upperLimitStepSize = mutator.upperLimitStepSize;
    }

    @Override
    public Object clone() {
        return new MutateESMutativeStepSizeControl(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateESMutativeStepSizeControl) {
            MutateESMutativeStepSizeControl mut = (MutateESMutativeStepSizeControl)mutator;
            if (this.mutationStepSize != mut.mutationStepSize) {
                return false;
            }
            if (this.alpha != mut.alpha) {
                return false;
            }
            if (this.lowerLimitStepSize != mut.lowerLimitStepSize) {
                return false;
            }
            return this.upperLimitStepSize == mut.upperLimitStepSize;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] range = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            this.mutationStepSize = RNG.flipCoin(0.5) ? (this.mutationStepSize *= this.alpha) : (this.mutationStepSize /= this.alpha);
            if (this.mutationStepSize < this.lowerLimitStepSize) {
                this.mutationStepSize = this.lowerLimitStepSize;
            }
            if (this.mutationStepSize > this.upperLimitStepSize) {
                this.mutationStepSize = this.upperLimitStepSize;
            }
            for (int i = 0; i < x.length; ++i) {
                int n = i;
                x[n] = x[n] + (range[i][1] - range[i][0]) / 2.0 * RNG.gaussianDouble(this.mutationStepSize);
                if (range[i][0] > x[i]) {
                    x[i] = range[i][0];
                }
                if (!(range[i][1] < x[i])) continue;
                x[i] = range[i][1];
            }
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "ES mutative step size control";
    }

    public String getName() {
        return "MSR";
    }

    public void setMutationStepSize(double d) {
        if (d < 0.0) {
            d = this.lowerLimitStepSize;
        }
        this.mutationStepSize = d;
    }

    public double getMutationStepSize() {
        return this.mutationStepSize;
    }

    public String mutationStepSizeTipText() {
        return "Choose the initial mutation step size.";
    }

    public void setLowerLimitStepSize(double d) {
        this.lowerLimitStepSize = d;
    }

    public double getLowerLimitStepSize() {
        return this.lowerLimitStepSize;
    }

    public String lowerLimitStepSizeTipText() {
        return "Set the lower limit for the mutation step size.";
    }

    public void setUpperLimitStepSize(double d) {
        this.upperLimitStepSize = d;
    }

    public double getUpperLimitStepSize() {
        return this.upperLimitStepSize;
    }

    public String upperLimitStepSizeTipText() {
        return "Set the upper limit for the mutation step size.";
    }

    public void setAlpha(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.alpha = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public String alphaTipText() {
        return "Set the value for alpha.";
    }
}

