/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The single step size is controlled using the evolution path.")
public class MutateESPathLengthAdaption
implements InterfaceMutation,
Serializable {
    private int dim;
    private double[] randZ;
    private double[] path;
    private double sigmaGlobal = 1.0;
    private double c;
    private boolean usePath = true;
    private double dampening = 1.0;
    private double expectedPathLen = -1.0;
    private double cu;

    public MutateESPathLengthAdaption() {
    }

    public MutateESPathLengthAdaption(MutateESPathLengthAdaption mutator) {
        this.usePath = true;
        this.dim = mutator.dim;
        this.sigmaGlobal = mutator.sigmaGlobal;
        this.c = mutator.c;
        this.dampening = mutator.dampening;
        this.expectedPathLen = mutator.expectedPathLen;
        this.cu = mutator.cu;
        if (mutator.randZ != null) {
            this.randZ = (double[])mutator.randZ.clone();
        }
        if (mutator.path != null) {
            this.path = (double[])mutator.path.clone();
        }
    }

    @Override
    public Object clone() {
        return new MutateESPathLengthAdaption(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateESPathLengthAdaption) {
            int i;
            MutateESPathLengthAdaption mut = (MutateESPathLengthAdaption)mutator;
            if (this.dim != mut.dim) {
                return false;
            }
            if (this.sigmaGlobal != mut.sigmaGlobal) {
                return false;
            }
            if (this.c != mut.c) {
                return false;
            }
            if (this.randZ != null && mut.randZ != null) {
                for (i = 0; i < this.randZ.length; ++i) {
                    if (this.randZ[i] == mut.randZ[i]) continue;
                    return false;
                }
            }
            if (this.path != null && mut.path != null) {
                for (i = 0; i < this.path.length; ++i) {
                    if (this.path[i] == mut.path[i]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        if (!(individual instanceof InterfaceESIndividual)) {
            return;
        }
        double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
        double[][] ranges = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
        this.dim = x.length;
        this.randZ = new double[this.dim];
        this.path = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.randZ[i] = RNG.gaussianDouble(1.0);
        }
        this.c = this.usePath ? 4.0 / (double)(this.dim + 4) : 1.0;
        this.expectedPathLen = Math.sqrt(this.dim) * (1.0 - 1.0 / (double)(4 * this.dim) + 1.0 / (double)(21 * this.dim * this.dim));
        this.dampening = 1.0 / this.c + 1.0;
        this.cu = Math.sqrt(this.c * (2.0 - this.c));
        this.mutateX(x, ranges, true);
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] ranges = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            this.adaptStrategy();
            this.calculateNewStep();
            this.mutateX(x, ranges, true);
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    private void checkRange(double[] x, double[][] ranges) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] < ranges[i][0]) {
                x[i] = ranges[i][0];
            }
            if (!(x[i] > ranges[i][1])) continue;
            x[i] = ranges[i][1];
        }
    }

    private void calculateNewStep() {
        for (int i = 0; i < this.dim; ++i) {
            this.randZ[i] = RNG.gaussianDouble(1.0);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    private void adaptStrategy() {
        for (int i = 0; i < this.dim; ++i) {
            this.path[i] = (1.0 - this.c) * this.path[i] + this.cu * this.randZ[i];
        }
        double pathLen = Mathematics.norm(this.path);
        double exp = (pathLen - this.expectedPathLen) / (this.dampening * this.expectedPathLen);
        this.sigmaGlobal *= Math.exp(exp);
    }

    private void mutateX(double[] x, double[][] range, boolean checkRange) {
        for (int i = 0; i < x.length; ++i) {
            int n = i;
            x[n] = x[n] + this.sigmaGlobal * this.randZ[i];
        }
        if (checkRange) {
            this.checkRange(x, range);
        }
    }

    @Override
    public String getStringRepresentation() {
        return "Mutation/Path-Length-Control";
    }

    public String getName() {
        return "Mutation/Path-Length-Control";
    }

    public void setSigmaGlobal(double d) {
        this.sigmaGlobal = d;
    }

    public double getSigmaGlobal() {
        return this.sigmaGlobal;
    }

    public String initSigmaGlobalTipText() {
        return "Set the initial global step size.";
    }
}

