/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceESIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The polynomial mutation alters all elements according to a polynomial distribution")
public class MutateESPolynomial
implements InterfaceMutation,
Serializable {
    private double eta = 0.2;

    public MutateESPolynomial() {
    }

    public MutateESPolynomial(MutateESPolynomial mutator) {
        this.eta = mutator.eta;
    }

    public MutateESPolynomial(double eta) {
        this.eta = eta;
    }

    @Override
    public Object clone() {
        return new MutateESPolynomial(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateESPolynomial) {
            MutateESPolynomial mut = (MutateESPolynomial)mutator;
            return this.eta == mut.eta;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceESIndividual) {
            double[] x = ((InterfaceESIndividual)((Object)individual)).getDGenotype();
            double[][] range = ((InterfaceESIndividual)((Object)individual)).getDoubleRange();
            for (int i = 0; i < x.length; ++i) {
                double r = RNG.randomDouble();
                double delta = 0.0;
                delta = r < 0.5 ? Math.pow(2.0 * r, 1.0 / (this.eta + 1.0)) - 1.0 : 1.0 - Math.pow(2.0 * (1.0 - r), 1.0 / (this.eta + 1.0));
                int n = i;
                x[n] = x[n] + delta;
                if (range[i][0] > x[i]) {
                    x[i] = range[i][0];
                }
                if (!(range[i][1] < x[i])) continue;
                x[i] = range[i][1];
            }
            ((InterfaceESIndividual)((Object)individual)).setDGenotype(x);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "ES fixed step size mutation";
    }

    public String getName() {
        return "ES polynomial mutation";
    }

    public void setEta(double a) {
        if (a < 0.0) {
            a = 0.0;
        }
        this.eta = a;
    }

    public double getEta() {
        return this.eta;
    }

    public String etaTipText() {
        return "Set the Eta_c value (the larger the value, the more restricted the search).";
    }
}

