/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import Jama.EigenvalueDecomposition;
import eva2.gui.editor.GenericObjectEditor;
import eva2.optimization.enums.ESMutationInitialSigma;
import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.EAIndividualComparator;
import eva2.optimization.individuals.InterfaceDataTypeDouble;
import eva2.optimization.operator.distancemetric.EuclideanMetric;
import eva2.optimization.operator.mutation.CMAParamSet;
import eva2.optimization.operator.mutation.InterfaceAdaptOperatorGenerational;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.EVAERROR;
import eva2.tools.Pair;
import eva2.tools.math.Mathematics;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The CMA mutator scheme with static cov. matrix, rank-mu update and weighted recombination.")
public class MutateESRankMuCMA
implements InterfaceAdaptOperatorGenerational,
InterfaceMutation,
Serializable {
    private double c_c;
    private double expRandStepLen;
    private static transient CMAParamSet lastParams = null;
    private ESMutationInitialSigma initializeSig = ESMutationInitialSigma.quarterRange;
    private double userDefInitSig = 0.2;
    private boolean doRankMuUpdate = true;
    private boolean checkRange = true;
    public static final String cmaParamsKey = "RankMuCMAParameters";

    public MutateESRankMuCMA() {
    }

    public MutateESRankMuCMA(MutateESRankMuCMA mutator) {
        this.c_c = mutator.c_c;
        this.expRandStepLen = mutator.expRandStepLen;
        this.initializeSig = mutator.initializeSig;
        this.userDefInitSig = mutator.userDefInitSig;
        this.checkRange = mutator.checkRange;
        this.doRankMuUpdate = mutator.doRankMuUpdate;
    }

    @Override
    public Object clone() {
        return new MutateESRankMuCMA(this);
    }

    public static double[] getMeanXOfPop(Population pop) {
        CMAParamSet params = (CMAParamSet)pop.getData(cmaParamsKey);
        if (params == null) {
            return null;
        }
        return params.meanX;
    }

    private double getInitSigma(Population initGen) {
        switch (this.initializeSig) {
            case avgInitialDistance: {
                return initGen.getPopulationMeasures(new EuclideanMetric())[0];
            }
            case userDefined: {
                return this.userDefInitSig;
            }
            case halfRange: {
                return -0.5;
            }
            case quarterRange: {
                return -0.25;
            }
        }
        throw new RuntimeException("Unknown initial sigma type!");
    }

    @Override
    public void adaptAfterSelection(Population oldGen, Population selectedP) {
        int j;
        double sum;
        int i;
        CMAParamSet params;
        Population selectedSorted = selectedP.getSortedBestFirst(new EAIndividualComparator(-1));
        int mu = selectedP.size();
        int lambda = oldGen.size();
        int generation = oldGen.getGeneration();
        if (mu >= lambda) {
            if (oldGen.hasData("EvolutionStrategyMuParameter")) {
                mu = (Integer)oldGen.getData("EvolutionStrategyMuParameter");
            }
            if (oldGen.hasData("EvolutionStrategyLambdaParameter")) {
                lambda = (Integer)oldGen.getData("EvolutionStrategyLambdaParameter");
            }
        }
        if (mu >= lambda) {
            mu = Math.max(1, lambda / 2);
            EVAERROR.errorMsgOnce("Warning: invalid mu/lambda ratio! Setting mu to lambda/2 = " + mu + ", lambda = " + lambda);
        }
        if (oldGen.getGeneration() <= 1) {
            params = oldGen.hasData(cmaParamsKey) ? CMAParamSet.initCMAParams((CMAParamSet)oldGen.getData(cmaParamsKey), mu, lambda, oldGen, this.getInitSigma(oldGen)) : CMAParamSet.initCMAParams(mu, lambda, oldGen, this.getInitSigma(oldGen));
        } else if (!oldGen.hasData(cmaParamsKey)) {
            if (oldGen.getGeneration() > 1) {
                EVAERROR.errorMsgOnce("Error: population lost cma parameters. Incompatible optimizer?");
            }
            params = CMAParamSet.initCMAParams(mu, lambda, oldGen, this.getInitSigma(oldGen));
        } else {
            params = (CMAParamSet)oldGen.getData(cmaParamsKey);
        }
        if (lambda == 1 && oldGen.size() == 1 && selectedP.size() == 1 && oldGen.getEAIndividual(0).equals(selectedP.getEAIndividual(0))) {
            lastParams = (CMAParamSet)params.clone();
            oldGen.putData(cmaParamsKey, params);
            selectedP.putData(cmaParamsKey, params);
            return;
        }
        double[] newMeanX = this.calcMeanX(params.weights, selectedSorted);
        int dim = params.meanX.length;
        double[] BDz = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            BDz[i2] = Math.sqrt(CMAParamSet.getMuEff(params.weights, mu)) * (newMeanX[i2] - params.meanX[i2]) / this.getSigma(params, i2);
        }
        double[] newPathS = (double[])params.pathS.clone();
        double[] newPathC = (double[])params.pathC.clone();
        double[] zVect = new double[dim];
        for (i = 0; i < dim; ++i) {
            sum = 0.0;
            for (j = 0; j < dim; ++j) {
                sum += params.mB.get(j, i) * BDz[j];
            }
            if (params.eigenvalues[i] < 0.0) {
                EVAERROR.errorMsgOnce("Warning: negative eigenvalue in MutateESRankMuCMA! (possibly multiple cases)");
                zVect[i] = 0.0;
                continue;
            }
            zVect[i] = sum / Math.sqrt(params.eigenvalues[i]);
            if (this.checkValidDouble(zVect[i])) continue;
            System.err.println("Error, infinite zVect entry!");
            zVect[i] = 0.0;
        }
        for (i = 0; i < dim; ++i) {
            sum = 0.0;
            for (j = 0; j < dim; ++j) {
                sum += params.mB.get(i, j) * zVect[j];
            }
            newPathS[i] = (1.0 - params.c_sig) * params.pathS[i] + Math.sqrt(params.c_sig * (2.0 - params.c_sig)) * sum;
            if (this.checkValidDouble(newPathS[i])) continue;
            System.err.println("Error, infinite pathS!");
        }
        double psNorm = Mathematics.norm(newPathS);
        double hsig = 0.0;
        if (psNorm / Math.sqrt(1.0 - Math.pow(1.0 - params.c_sig, 2.0 * (double)generation)) / this.expRandStepLen < 1.4 + 2.0 / ((double)dim + 1.0)) {
            hsig = 1.0;
        }
        for (int i3 = 0; i3 < dim; ++i3) {
            newPathC[i3] = (1.0 - this.getCc()) * params.pathC[i3] + hsig * Math.sqrt(this.getCc() * (2.0 - this.getCc())) * BDz[i3];
            this.checkValidDouble(newPathC[i3]);
        }
        if (params.meanX == null) {
            params.meanX = newMeanX;
        }
        this.updateCov(params, newPathC, newMeanX, hsig, mu, selectedSorted);
        this.updateBD(params);
        double sigFact = Math.exp((psNorm / this.expRandStepLen - 1.0) * params.c_sig / params.d_sig);
        params.sigma = Double.isInfinite(sigFact) ? (params.sigma *= 10.0) : (params.sigma *= sigFact);
        if (!this.testAndCorrectNumerics(params, generation, selectedSorted)) {
            params = CMAParamSet.initCMAParams(params, mu, lambda, params.meanX, ((InterfaceDataTypeDouble)((Object)oldGen.getEAIndividual(0))).getDoubleRange(), params.firstSigma);
        }
        params.meanX = newMeanX;
        params.pathC = newPathC;
        params.pathS = newPathS;
        params.firstAdaptionDone = true;
        lastParams = (CMAParamSet)params.clone();
        oldGen.putData(cmaParamsKey, params);
        selectedP.putData(cmaParamsKey, params);
    }

    @Override
    public void adaptGenerational(Population oldPop, Population selectedPop, Population newPop, boolean updateSelected) {
        if (!newPop.hasData(cmaParamsKey)) {
            if (!oldPop.hasData(cmaParamsKey)) {
                System.err.println("warning: no cma param set found (MutateESRankMuCMA!");
            } else {
                newPop.putData(cmaParamsKey, oldPop.getData(cmaParamsKey));
            }
        }
    }

    private boolean testAndCorrectNumerics(CMAParamSet params, int iterations, Population selected) {
        boolean corrected = true;
        if (iterations > 1 && selected.size() > 1 && this.nearlySame(selected.getEAIndividual(0).getFitness(), selected.getEAIndividual(selected.size() - 1).getFitness())) {
            params.sigma *= Math.exp(0.2 + params.c_sig / params.d_sig);
        }
        if (!this.checkValidDouble(params.sigma)) {
            System.err.println("Error, unstable sigma!");
            corrected = false;
        }
        double fac = 1.0;
        double minEig = 1.0E-12;
        double maxEig = 1.0E8;
        if (Mathematics.max(params.eigenvalues) < minEig) {
            fac = 1.0 / Math.sqrt(Mathematics.max(params.eigenvalues));
        } else if (Mathematics.min(params.eigenvalues) > maxEig) {
            fac = 1.0 / Math.sqrt(Mathematics.min(params.eigenvalues));
        }
        if (fac != 1.0) {
            params.sigma /= fac;
            for (int i = 0; i < params.meanX.length; ++i) {
                int n = i;
                params.pathC[n] = params.pathC[n] * fac;
                int n2 = i;
                params.eigenvalues[n2] = params.eigenvalues[n2] * (fac * fac);
                for (int j = 0; j <= i; ++j) {
                    params.mC.set(i, j, params.mC.get(i, j) * fac * fac);
                    if (i == j) continue;
                    params.mC.set(j, i, params.mC.get(i, j));
                }
            }
        }
        return corrected;
    }

    private boolean nearlySame(double[] bestFitness, double[] worstFitness) {
        double epsilon = 1.0E-14;
        for (int i = 0; i < bestFitness.length; ++i) {
            if (!(Math.abs(bestFitness[i] - worstFitness[i]) > epsilon)) continue;
            return false;
        }
        return true;
    }

    private double getSigma(CMAParamSet params, int i) {
        return params.sigma;
    }

    private double getCc() {
        return this.c_c;
    }

    private double calcExpRandStepLen(int dim) {
        return Math.sqrt(dim) * (1.0 - 1.0 / (double)(4 * dim) + 1.0 / (double)(21 * dim * dim));
    }

    private void updateCov(CMAParamSet params, double[] newPathC, double[] newMeanX, double hsig, int mu, Population selected) {
        double newVal = 0.0;
        int dim = newMeanX.length;
        double ccv = this.getCCov(params.weights, mu, dim);
        if (ccv > 0.0) {
            int j;
            int i;
            double mcv = CMAParamSet.getMuCov(params.weights, mu);
            for (i = 0; i < dim; ++i) {
                for (j = 0; j <= i; ++j) {
                    newVal = (1.0 - ccv) * params.mC.get(i, j) + ccv * (1.0 / mcv) * (newPathC[i] * newPathC[j] + (1.0 - hsig) * this.getCc() * (2.0 - this.getCc()) * params.mC.get(i, j));
                    this.checkValidDouble(newVal);
                    params.mC.set(i, j, newVal);
                    if (!this.isRankMu()) continue;
                    for (int k = 0; k < mu; ++k) {
                        double[] x_k = AbstractEAIndividual.getDoublePositionShallow(selected.getEAIndividual(k));
                        newVal = params.mC.get(i, j) + ccv * (1.0 - 1.0 / mcv) * params.weights[k] * (x_k[i] - params.meanX[i]) * (x_k[j] - params.meanX[j]) / (this.getSigma(params, i) * this.getSigma(params, j));
                        this.checkValidDouble(newVal);
                        params.mC.set(i, j, newVal);
                    }
                }
            }
            for (i = 0; i < dim; ++i) {
                for (j = i + 1; j < dim; ++j) {
                    params.mC.set(i, j, params.mC.get(j, i));
                }
            }
            if (params.mC.get(0, 1) != params.mC.get(1, 0)) {
                System.err.println("WARNING, C is not symmetric!");
            }
        }
    }

    public boolean isRankMu() {
        return this.doRankMuUpdate;
    }

    public void setRankMu(boolean rankUpd) {
        this.doRankMuUpdate = rankUpd;
    }

    public String rankMuTipText() {
        return "Choose between rank one and rank mu update.";
    }

    private boolean checkValidDouble(double v) {
        boolean valid;
        boolean bl = valid = !Double.isNaN(v) && !Double.isInfinite(v);
        if (!valid) {
            System.err.println("Invalid double in rankMuCMA!");
        }
        return valid;
    }

    private double getCCov(double[] weights, int mu, int dim) {
        double muC = CMAParamSet.getMuCov(weights, mu);
        double muE = CMAParamSet.getMuEff(weights, mu);
        double ccov = 2.0 / (muC * Math.pow((double)dim + Math.sqrt(2.0), 2.0)) + (1.0 - 1.0 / muC) * Math.min(1.0, (2.0 * muE - 1.0) / ((double)(dim * dim + 2 * dim + 4) + muE));
        return ccov;
    }

    private void outputParams(CMAParamSet params, int mu) {
        System.out.println("sigma=" + params.sigma + " chiN=" + this.expRandStepLen + " cs=" + params.c_sig + " damps=" + params.d_sig + " Cc=" + this.getCc() + " Ccov=" + this.getCCov(params.weights, mu, params.meanX.length) + " mueff=" + CMAParamSet.getMuEff(params.weights, mu) + " mucov=" + CMAParamSet.getMuCov(params.weights, mu));
    }

    private void updateBD(CMAParamSet params) {
        params.mC = params.mC.plus(params.mC.transpose()).times(0.5);
        EigenvalueDecomposition helper = new EigenvalueDecomposition(params.mC);
        params.mB = helper.getV();
        params.eigenvalues = helper.getRealEigenvalues();
    }

    private double[] calcMeanX(double[] weights, Population selectedPop) {
        return selectedPop.getCenterWeighted(weights);
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    public String getName() {
        return "Rank-Mu-CMA-Mutator";
    }

    @Override
    public String getStringRepresentation() {
        return "Rank-Mu-CMA-Mutator";
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
        double[][] range = ((InterfaceDataTypeDouble)((Object)individual)).getDoubleRange();
        int dim = range.length;
        this.c_c = 4.0 / (double)(dim + 4);
        this.expRandStepLen = this.calcExpRandStepLen(dim);
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceDataTypeDouble) {
            double[] x = ((InterfaceDataTypeDouble)((Object)individual)).getDoubleData();
            double[][] range = ((InterfaceDataTypeDouble)((Object)individual)).getDoubleRange();
            ((InterfaceDataTypeDouble)((Object)individual)).setDoubleGenotype(this.mutate(lastParams, x, range, 0));
        } else {
            System.err.println("Error, expecting InterfaceDataTypeDouble");
        }
    }

    private double[] mutate(CMAParamSet params, double[] x, double[][] range, int count) {
        int dim = range.length;
        if (!Mathematics.isInRange(params.meanX, range)) {
            System.err.println("Error in MutateESRankMuCMA.mutate !");
            Mathematics.projectToRange(params.meanX, range);
        }
        if (params != null && params.firstAdaptionDone) {
            double[] sampl = new double[dim];
            for (int i = 0; i < dim; ++i) {
                sampl[i] = Math.sqrt(params.eigenvalues[i]) * RNG.gaussianDouble(1.0);
                if (!Double.isNaN(sampl[i])) continue;
                sampl[i] = 0.0;
            }
            this.addMutationStep(params, x, sampl);
            int cnt = 0;
            while (!Mathematics.isInRange(x, range)) {
                double r;
                if (++cnt > 10 * x.length) {
                    r = 0.0;
                } else {
                    r = RNG.randomDouble(-0.5, 0.5);
                    if (Math.abs(r) < 0.5) {
                        r += Math.signum(r) * 0.5;
                    }
                }
                Mathematics.svMult(r, sampl, sampl);
                this.addMutationStep(params, x, sampl);
            }
        } else {
            if (params == null) {
                System.err.println("Error in MutateESRankMuCMA: parameter set was null! Skipping mutation...");
            }
            for (int i = 0; i < dim; ++i) {
                int n = i;
                x[n] = x[n] + RNG.gaussianDouble(this.getSigma(params, i));
                this.checkValidDouble(x[i]);
            }
        }
        if (!Mathematics.isInRange(params.meanX, range)) {
            System.err.println("Error B in MutateESRankMuCMA.mutate !");
        }
        return x;
    }

    private void addMutationStep(CMAParamSet params, double[] x, double[] sampl) {
        for (int i = 0; i < x.length; ++i) {
            double sum = 0.0;
            for (int j = 0; j < x.length; ++j) {
                sum += params.mB.get(i, j) * sampl[j];
            }
            x[i] = params.meanX[i] + this.getSigma(params, i) * sum;
            this.checkValidDouble(x[i]);
        }
    }

    private double[] mutateOrig(CMAParamSet params, double[] x, double[][] range, int count) {
        int dim = range.length;
        int maxRetries = this.checkRange ? 100 * dim : 0;
        do {
            if (params != null && params.firstAdaptionDone) {
                int i;
                double[] sampl = new double[dim];
                for (i = 0; i < dim; ++i) {
                    sampl[i] = Math.sqrt(params.eigenvalues[i]) * RNG.gaussianDouble(1.0);
                    if (!Double.isNaN(sampl[i])) continue;
                    sampl[i] = 0.0;
                }
                for (i = 0; i < dim; ++i) {
                    double sum = 0.0;
                    for (int j = 0; j < dim; ++j) {
                        sum += params.mB.get(i, j) * sampl[j];
                    }
                    x[i] = params.meanX[i] + this.getSigma(params, i) * sum;
                    this.checkValidDouble(x[i]);
                }
            } else {
                if (params == null) {
                    System.err.println("Error in MutateESRankMuCMA: parameter set was null! Skipping mutation...");
                }
                for (int i = 0; i < dim; ++i) {
                    int n = i;
                    x[n] = x[n] + RNG.gaussianDouble(this.getSigma(params, i));
                    this.checkValidDouble(x[i]);
                }
            }
        } while (maxRetries-- > 0 && !Mathematics.isInRange(x, range));
        if (this.checkRange && !Mathematics.isInRange(x, range)) {
            return this.repairMutation(x, range);
        }
        return x;
    }

    private double[] repairMutation(double[] x, double[][] range) {
        EVAERROR.errorMsgOnce("Warning, brute-forcing constraints! Too large initial sigma? (pot. multiple errors)");
        Mathematics.projectToRange(x, range);
        return x;
    }

    public double getFirstSigma(Population pop) {
        return ((CMAParamSet)pop.getData((String)cmaParamsKey)).firstSigma;
    }

    public void hideHideable() {
        this.setInitializeSigma(this.getInitializeSigma());
    }

    public ESMutationInitialSigma getInitializeSigma() {
        return this.initializeSig;
    }

    public void setInitializeSigma(ESMutationInitialSigma initialSig) {
        this.initializeSig = initialSig;
        GenericObjectEditor.setHideProperty(this.getClass(), "userDefInitSig", initialSig != ESMutationInitialSigma.userDefined);
    }

    public String initializeSigmaTipText() {
        return "Method to use for setting the initial step size.";
    }

    public boolean testAllDistBelow(Population pop, double tolX) {
        boolean res = true;
        CMAParamSet params = (CMAParamSet)pop.getData(cmaParamsKey);
        for (int i = 0; res && i < params.meanX.length; ++i) {
            res = res && this.getSigma(params, i) * Math.max(Math.abs(params.pathC[i]), Math.sqrt(params.mC.get(i, i))) < tolX;
        }
        return res;
    }

    public boolean testNoChangeAddingDevAxis(Population pop, double d, int gen) {
        CMAParamSet params = (CMAParamSet)pop.getData(cmaParamsKey);
        int dim = params.meanX.length;
        int k = gen % dim;
        double[] ev_k = Mathematics.getColumn(params.mB, k);
        Mathematics.svMult(Math.sqrt(params.eigenvalues[k]), ev_k, ev_k);
        boolean res = true;
        for (int i = 0; res && i < dim; ++i) {
            res = res && params.meanX[i] == params.meanX[i] + d * this.getSigma(params, i) * ev_k[i];
        }
        return res;
    }

    public boolean testNoEffectCoord(Population pop, double d) {
        boolean ret = false;
        CMAParamSet params = (CMAParamSet)pop.getData(cmaParamsKey);
        for (int i = 0; i < params.meanX.length && !ret; ++i) {
            ret = ret || params.meanX[i] == params.meanX[i] + d * this.getSigma(params, i) * Math.sqrt(params.mC.get(i, i));
        }
        return ret;
    }

    public boolean testCCondition(Population pop, double d) {
        CMAParamSet params = (CMAParamSet)pop.getData(cmaParamsKey);
        Pair<Double, Double> minMax = Mathematics.getMinMaxDiag(params.mC);
        return (Double)minMax.head <= 0.0 || (Double)minMax.tail >= d;
    }

    public double getUserDefInitSig() {
        return this.userDefInitSig;
    }

    public void setUserDefInitSig(double userDefInitSig) {
        this.userDefInitSig = userDefInitSig;
    }

    public String userDefInitSigTipText() {
        return "Set a manual initial sigma which should be related to the initial individual distribution.";
    }

    public boolean isCheckRange() {
        return this.checkRange;
    }

    public void setCheckRange(boolean checkRange) {
        this.checkRange = checkRange;
    }

    public String checkRangeTipText() {
        return "Force the operator to remain within the problem range.";
    }
}

