/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.operator.mutation.InterfaceAdaptOperatorGenerational;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.operator.mutation.MutateESFixedStepSize;
import eva2.optimization.population.Population;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="The 1/5 success rule works only together with an ES optimizer.")
public class MutateESSuccessRule
extends MutateESFixedStepSize
implements InterfaceMutation,
InterfaceAdaptOperatorGenerational,
Serializable {
    protected double successRate = 0.2;
    protected double alpha = 1.2;

    public MutateESSuccessRule() {
    }

    public MutateESSuccessRule(MutateESSuccessRule mutator) {
        super(mutator);
        this.successRate = mutator.successRate;
        this.alpha = mutator.alpha;
    }

    @Override
    public Object clone() {
        return new MutateESSuccessRule(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateESSuccessRule) {
            MutateESSuccessRule mut = (MutateESSuccessRule)mutator;
            if (this.sigma != mut.sigma) {
                return false;
            }
            if (this.successRate != mut.successRate) {
                return false;
            }
            return this.alpha == mut.alpha;
        }
        return false;
    }

    @Override
    public String getStringRepresentation() {
        return "ES 1/5 Success Rule mutation";
    }

    public void increaseMutationStepSize() {
        this.sigma *= this.alpha;
    }

    public void decreaseMutationStepSize() {
        this.sigma /= this.alpha;
    }

    @Override
    public String getName() {
        return "ES 1/5 Success Rule mutation";
    }

    public String mutationStepSizeTipText() {
        return "Choose the initial mutation step size.";
    }

    public void setSuccessRate(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.successRate = d;
    }

    public double getSuccessRate() {
        return this.successRate;
    }

    public String successRateTipText() {
        return "Set success rate (0.2 is default).";
    }

    public void setAlpha(double d) {
        if (d < 1.0) {
            d = 1.0;
        }
        this.alpha = d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public String alphaTipText() {
        return "Choose the factor > 1 by which the mutation step size is to be increased/decreased.";
    }

    @Override
    public String sigmaTipText() {
        return "The initial step size.";
    }

    @Override
    public void adaptAfterSelection(Population oldGen, Population selected) {
    }

    @Override
    public void adaptGenerational(Population selectedPop, Population parentPop, Population newPop, boolean updateSelected) {
        MutateESSuccessRule mutator;
        int i;
        double rate = 0.0;
        for (i = 0; i < parentPop.size(); ++i) {
            if (!(newPop.getEAIndividual(i).getFitness(0) < parentPop.getEAIndividual(i).getFitness(0))) continue;
            rate += 1.0;
        }
        rate /= (double)parentPop.size();
        if (updateSelected) {
            for (i = 0; i < selectedPop.size(); ++i) {
                mutator = (MutateESSuccessRule)((AbstractEAIndividual)selectedPop.get(i)).getMutationOperator();
                this.updateMutator(rate, mutator);
            }
        }
        for (i = 0; i < newPop.size(); ++i) {
            mutator = (MutateESSuccessRule)((AbstractEAIndividual)newPop.get(i)).getMutationOperator();
            this.updateMutator(rate, mutator);
        }
    }

    private void updateMutator(double rate, MutateESSuccessRule mutator) {
        if (rate < mutator.getSuccessRate()) {
            mutator.decreaseMutationStepSize();
        } else {
            mutator.increaseMutationStepSize();
        }
    }
}

