/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="The standard mutation switches n bits of the GA genotype.")
public class MutateGAAdaptive
implements InterfaceMutation,
Serializable {
    protected double mutationStep = 1.0;
    protected double tau1 = 0.15;
    protected double lowerLimitStepSize = 5.0E-7;

    public MutateGAAdaptive() {
    }

    public MutateGAAdaptive(MutateGAAdaptive mutator) {
        this.mutationStep = mutator.mutationStep;
        this.tau1 = mutator.tau1;
        this.lowerLimitStepSize = mutator.lowerLimitStepSize;
    }

    @Override
    public Object clone() {
        return new MutateGAAdaptive(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGAAdaptive) {
            MutateGAAdaptive mut = (MutateGAAdaptive)mutator;
            if (this.mutationStep != mut.mutationStep) {
                return false;
            }
            if (this.tau1 != mut.tau1) {
                return false;
            }
            return this.lowerLimitStepSize == mut.lowerLimitStepSize;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGAIndividual) {
            BitSet tmpBitSet = ((InterfaceGAIndividual)((Object)individual)).getBGenotype();
            this.mutationStep *= Math.exp(this.tau1 * RNG.gaussianDouble(1.0));
            if (this.mutationStep < this.lowerLimitStepSize) {
                this.mutationStep = this.lowerLimitStepSize;
            }
            for (int i = 0; i < ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength(); ++i) {
                if (!RNG.flipCoin(this.mutationStep / (double)((InterfaceGAIndividual)((Object)individual)).getGenotypeLength())) continue;
                tmpBitSet.flip(i);
            }
            ((InterfaceGAIndividual)((Object)individual)).setBGenotype(tmpBitSet);
        }
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public String getStringRepresentation() {
        return "GA adaptive mutation";
    }

    public String getName() {
        return "GA adaptive mutation";
    }

    public void setMutationStep(double d) {
        if (d < 0.0) {
            d = this.lowerLimitStepSize;
        }
        this.mutationStep = d;
    }

    public double getMutationStepSize() {
        return this.mutationStep;
    }

    public String mutationStepSizeTipText() {
        return "Choose the initial mutation step size.";
    }

    public void setLowerLimitStepSize(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.lowerLimitStepSize = d;
    }

    public double getLowerLimitStepSize() {
        return this.lowerLimitStepSize;
    }

    public String lowerLimitStepSizeTipText() {
        return "Set the lower limit for the mutation step size.";
    }

    public void setTau1(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.tau1 = d;
    }

    public double getTau1() {
        return this.tau1;
    }

    public String tau1TipText() {
        return "Set the value for tau1.";
    }
}

