/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.individuals.AbstractEAIndividual;
import eva2.optimization.individuals.InterfaceGAIndividual;
import eva2.optimization.individuals.InterfaceGIIndividual;
import eva2.optimization.operator.mutation.InterfaceMutation;
import eva2.optimization.population.Population;
import eva2.problems.InterfaceOptimizationProblem;
import eva2.tools.math.RNG;
import eva2.util.annotation.Description;
import java.io.Serializable;
import java.util.BitSet;

@Description(value="This mutation operator swaps n random position pairs (bits or integers). The number of mutations is chosen uniformly in a given interval.")
public class MutateGAGISwapBits
implements InterfaceMutation,
Serializable {
    private int minNumMutations = 1;
    private int maxNumMutations = 3;
    private boolean preferTrueChange = true;

    public MutateGAGISwapBits() {
    }

    public MutateGAGISwapBits(MutateGAGISwapBits mutator) {
        this.minNumMutations = mutator.minNumMutations;
        this.maxNumMutations = mutator.maxNumMutations;
        this.setPreferTrueChange(mutator.isPreferTrueChange());
    }

    public MutateGAGISwapBits(int minMutations, int maxMutations, boolean preferTrueChange) {
        this.minNumMutations = minMutations;
        this.maxNumMutations = maxMutations;
        this.preferTrueChange = preferTrueChange;
    }

    @Override
    public Object clone() {
        return new MutateGAGISwapBits(this);
    }

    @Override
    public boolean equals(Object mutator) {
        if (mutator instanceof MutateGAGISwapBits) {
            MutateGAGISwapBits mut = (MutateGAGISwapBits)mutator;
            if (this.minNumMutations != mut.minNumMutations) {
                return false;
            }
            return this.maxNumMutations == mut.maxNumMutations;
        }
        return false;
    }

    @Override
    public void initialize(AbstractEAIndividual individual, InterfaceOptimizationProblem opt) {
    }

    @Override
    public void crossoverOnStrategyParameters(AbstractEAIndividual indy1, Population partners) {
    }

    @Override
    public void mutate(AbstractEAIndividual individual) {
        if (individual instanceof InterfaceGAIndividual || individual instanceof InterfaceGIIndividual) {
            Object genotype = null;
            int genoLen = -1;
            if (individual instanceof InterfaceGAIndividual) {
                genotype = ((InterfaceGAIndividual)((Object)individual)).getBGenotype();
                genoLen = ((InterfaceGAIndividual)((Object)individual)).getGenotypeLength();
            } else {
                genotype = ((InterfaceGIIndividual)((Object)individual)).getIGenotype();
                genoLen = ((InterfaceGIIndividual)((Object)individual)).getGenotypeLength();
            }
            int[][] mutationIndices = this.selectMutationIndices(genoLen, genotype);
            for (int i = 0; i < mutationIndices.length; ++i) {
                Object tmp = this.valueAt(genotype, mutationIndices[i][1]);
                this.setValueAt(genotype, mutationIndices[i][1], this.valueAt(genotype, mutationIndices[i][0]));
                this.setValueAt(genotype, mutationIndices[i][0], tmp);
            }
            if (genotype instanceof BitSet) {
                ((InterfaceGAIndividual)((Object)individual)).setBGenotype((BitSet)genotype);
            } else {
                ((InterfaceGIIndividual)((Object)individual)).setIGenotype((int[])genotype);
            }
        }
    }

    protected int[][] selectMutationIndices(int genoLen, Object genotype) {
        int numMutes = RNG.randomInt(this.minNumMutations, this.maxNumMutations);
        int[][] mutationIndices = new int[numMutes][2];
        for (int i = 0; i < mutationIndices.length; ++i) {
            mutationIndices[i][0] = this.getRandomIndex(genoLen, genotype, -1);
            mutationIndices[i][1] = this.getRandomIndex(genoLen, genotype, mutationIndices[i][0]);
        }
        return mutationIndices;
    }

    private void setValueAt(Object genotype, int i, Object val) {
        if (genotype instanceof BitSet) {
            ((BitSet)genotype).set(i, (Boolean)val);
        } else {
            ((int[])genotype)[i] = (Integer)val;
        }
    }

    protected int getRandomIndex(int genoLen, Object genotype, int lastIndex) {
        return this.getRandomIndex(genoLen / 2, genotype, lastIndex >= 0 ? this.valueAt(genotype, lastIndex) : null, 0, genoLen - 1);
    }

    protected int getRandomIndex(int maxTries, Object genotype, Object avoidValue, int iMin, int iMax) {
        int k = RNG.randomInt(iMin, iMax);
        if (this.isPreferTrueChange() && avoidValue != null) {
            while (avoidValue == this.valueAt(genotype, k) && maxTries >= 0) {
                k = RNG.randomInt(iMin, iMax);
                --maxTries;
            }
        }
        return k;
    }

    protected Object valueAt(Object genotype, int k) {
        if (genotype instanceof BitSet) {
            return ((BitSet)genotype).get(k);
        }
        return ((int[])genotype)[k];
    }

    @Override
    public String getStringRepresentation() {
        return "GA/GI swap values mutation";
    }

    public String getName() {
        return "GA-GI swap bits mutation";
    }

    public void setMinNumberOfMutations(int mutations) {
        if (mutations < 0) {
            mutations = 0;
        }
        this.minNumMutations = mutations;
    }

    public int getMinNumberOfMutations() {
        return this.minNumMutations;
    }

    public String minNumberOfMutationsTipText() {
        return "The minimum number of values to be swapped.";
    }

    public void setMaxNumberOfMutations(int mutations) {
        if (mutations < 0) {
            mutations = 0;
        }
        this.maxNumMutations = mutations;
    }

    public int getMaxNumberOfMutations() {
        return this.maxNumMutations;
    }

    public String maxNumberOfMutationsTipText() {
        return "The maximum number of values to be swapped.";
    }

    public void setPreferTrueChange(boolean preferPairs) {
        this.preferTrueChange = preferPairs;
    }

    public boolean isPreferTrueChange() {
        return this.preferTrueChange;
    }

    public String preferTrueChangeTipText() {
        return "If set to true, mutation events will prefer swapping non-equal values";
    }
}

