/*
 * Decompiled with CFR 0.152.
 */
package eva2.optimization.operator.mutation;

import eva2.optimization.operator.mutation.MutateGAGISwapBits;
import eva2.tools.EVAERROR;
import eva2.util.annotation.Description;
import java.io.Serializable;

@Description(value="Segment-wise swapping of elements - the mutation pairs are selected within the same sub-sequence of the genotype.")
public class MutateGAGISwapBitsSegmentwise
extends MutateGAGISwapBits
implements Serializable {
    private int segmentLength = 8;

    public MutateGAGISwapBitsSegmentwise() {
    }

    public MutateGAGISwapBitsSegmentwise(MutateGAGISwapBitsSegmentwise mutator) {
        super(mutator);
        this.segmentLength = mutator.segmentLength;
    }

    public MutateGAGISwapBitsSegmentwise(int segmentLength) {
        this();
        this.segmentLength = segmentLength;
    }

    public MutateGAGISwapBitsSegmentwise(int segmentLen, int minMutations, int maxMutations, boolean preferTrueChange) {
        super(minMutations, maxMutations, preferTrueChange);
        this.segmentLength = segmentLen;
    }

    @Override
    public Object clone() {
        return new MutateGAGISwapBitsSegmentwise(this);
    }

    @Override
    public String getName() {
        return "GA-GI swap bits segment-wise mutation";
    }

    @Override
    protected int getRandomIndex(int genoLen, Object genotype, int lastIndex) {
        int iMin = 0;
        int iMax = genoLen - 1;
        if (lastIndex >= 0 && (iMax = (iMin = this.segmentLength * lastIndex / this.segmentLength) + this.segmentLength - 1) >= genoLen) {
            EVAERROR.errorMsgOnce("Warning, the last segment exceeds the genotype length (so it is not a multiple of the genotype length");
            iMax = genoLen - 1;
        }
        return super.getRandomIndex(this.segmentLength / 2, genotype, lastIndex >= 0 ? this.valueAt(genotype, lastIndex) : null, iMin, iMax);
    }

    public int getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(int segmentLength) {
        this.segmentLength = segmentLength;
    }

    public String segmentLengthTipText() {
        return "The length of subsequences to which mutations are restricted";
    }
}

